package sr5e1_power.impl

import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import org.eclipse.emf.common.notify.Notification
import org.eclipse.emf.common.notify.impl.AdapterImpl
import sr5e1_power.DSPIConfig

// This class overrides the generated class and will be instantiated by factory
class DSPIConfigImpl extends MDSPIConfigImpl implements DSPIConfig {
	new() {
		enabled = true
		
		this.eAdapters.add(new AdapterImpl() {
			override notifyChanged(Notification arg0) {
				val parent = eContainer as DSPIImpl
				if (parent !== null) {
					parent.eNotify(arg0);
				}
			}
		});
	}

	override getIDD_HV_IO() {
		0.0
	}

	override getIDD_HV() {
		0.0
	}

	override getIDD_HV_ADC() {
		0.0
	}

	override getIDD_LV() {
		val Cluster cluster = ConsumptionHelper.getCluster(this)
		if(cluster === null) return 0.0
		if (isAllowed) {
			val parent = eContainer as DSPIImpl

			switch (baudRate) {
				case E5M_HZ:
					return PowerUtils.round(3.0 * (parent.multiplyFactor / 100.0))
				case E10M_HZ:
					return PowerUtils.round(3.0 * (parent.multiplyFactor / 100.0))
				case E20M_HZ:
					return PowerUtils.round(3.0 * (parent.multiplyFactor / 100.0))
			}
		}
		0.0
	}

	override describe(int indent) {
		val result = new StringBuilder("\t".repeat(indent))
		if (isAllowed) {
			result.append(" (Factor: ")
			result.append(multiplyFactor)
			result.append("%, ")
			result.append("baudRate: ")
			result.append(baudRate)
			result.append(')\n')
		}
		result.toString()
	}
}
