package sr5e1_power.impl

import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import sr5e1_power.Cluster0
import sr5e1_power.Core_2
import sr5e1_power.Sr5e1_powerPackage

// This class overrides the generated class and will be instantiated by factory
class Core_2Impl extends MCore_2Impl implements Core_2 {

	new() {
		enabled = false
	}

	override validChipModes() {
		"RUN";
	}

	override getIDD_HV() {
		0.0
	}

	override getIDD_HV_ADC() {
		0.0
	}

	override getIDD_HV_IO() {
		return 0.0
	}

	@DependsOn(source=Sr5e1_powerPackage.CORE_2__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.CORE_2__ENABLED,
		Sr5e1_powerPackage.CORE_2__MULTIPLY_FACTOR
	])
	override getIDD_LV() {
		val Cluster cluster = ConsumptionHelper.getCluster(this)
		if(cluster === null) return 0.0
		val clock = (cluster as Cluster0).SYS_CLK
		if (isAllowed) {
			switch (clock) {
				case "100":
					return PowerUtils.round(12.0 * ((this.multiplyFactor / 100.0)))
				case "200":
					return PowerUtils.round(25.0 * ((this.multiplyFactor / 100.0)))
				case "300":
					return PowerUtils.round(35.0 * ((this.multiplyFactor / 100.0)))
			}
		}

		return 0.0

	}

	override describe(int indent) {
		if (isAllowed) {
			val result = new StringBuilder("\t".repeat(indent) + this.id)
			result.append(" (Factor: ")
			result.append(multiplyFactor)
			result.append("%, ")
			result.append(')\n');
			result.toString()
		} else {
			""
		}
	}

	@DependsOn(source=Sr5e1_powerPackage.CORE_2__ALLOWED, dependencies=#[
		Sr5e1_powerPackage.CORE_2__ENABLED
		])
	override isAllowed() {
		super.isAllowed()
	}

}
