package sr5e1_power.impl

import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.MConsumptionPackage
import com.st.stellar.consumption.model.consumption.RunMode
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import org.eclipse.xtext.EcoreUtil2
import sr5e1_power.Cluster0
import sr5e1_power.PowerConsumption
import sr5e1_power.Sr5e1_powerPackage

// This class overrides the generated class and will be instantiated by factory
class Cluster0Impl extends MCluster0Impl implements Cluster0 {

	new() {
		enabled = true
		SYS_CLK = "300"
	}

	override describe(int indent) {
		if (isAllowed) {
			val result = new StringBuilder("\t".repeat(indent) + this.id)
			result.append(
				" " + this.syS_CLK + " " + ConsumptionHelper.getUnit(MConsumptionPackage.eINSTANCE.cluster_SYS_CLK) +
					" " + chipMode + "\n")
			result.append(core_1.describe(indent + 1))
			result.append(core_2.describe(indent + 1))
			result.toString()
		} else {
			""
		}
	}

	override getChipMode() {
		val root = EcoreUtil2.getRootContainer(this) as PowerConsumption;
		val res = RunMode.get(root.general.chipMode)
		if (res === null) {
			RunMode.RUN
		} else {
			res
		}
	}

	override getChipModeString() {
		getChipMode.literal
	}

	@DependsOn(source=Sr5e1_powerPackage.CLUSTER0__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.CLUSTER0__ENABLED,
		Sr5e1_powerPackage.CLUSTER0__SYS_CLK,
		Sr5e1_powerPackage.CLUSTER0__MULTIPLY_FACTOR
	])
	override getIDD_LV() {
		super.getIDD_LV()
	}

}
