package sr5e1_power.impl

import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.MConsumptionPackage
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import sr5e1_power.CAN
import sr5e1_power.CANBaudRate
import sr5e1_power.Sr5e1_powerPackage

// This class overrides the generated class and will be instantiated by factory
class CANImpl extends MCANImpl implements CAN {
	new() {
		enabled = false
		IP_CLK = "40"
	}

	override describe(int indent) {
		if (isAllowed) {
			val result = new StringBuilder("\t".repeat(indent) + this.id)
			result.append(" (clock: ")
			result.append(iP_CLK.toString + " " +
				ConsumptionHelper.getUnit(MConsumptionPackage.eINSTANCE.peripheral_IP_CLK))
			result.append(')\n')
			result.append(activeConfig.describe(indent + 1))

			result.toString()
		} else {
			""
		}
	}

	@DependsOn(source=Sr5e1_powerPackage.CAN__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.CAN__ENABLED,
		Sr5e1_powerPackage.CAN__IP_CLK,
		Sr5e1_powerPackage.CAN_CONFIG__BAUD_RATE,
		Sr5e1_powerPackage.CAN__MULTIPLY_FACTOR
	])
	override getIDD_LV() {
		//activeConfig.IDD_LV
		
		val Cluster cluster = ConsumptionHelper.getCluster(this)
		if(cluster === null) return 0.0
		if (isAllowed) {
			switch (activeConfig.baudRate) {
				case CANBaudRate.E1_MBPS:
					return PowerUtils.round(4.0 * (multiplyFactor / 100.0))
				case CANBaudRate.E2_MBPS:
					return PowerUtils.round(5.0 * (multiplyFactor / 100.0))
				default: {
					return 0.0
				}
			}
		}
		return 0.0
	}

	@DependsOn(source=Sr5e1_powerPackage.CAN__ALLOWED, dependencies=#[
		Sr5e1_powerPackage.CAN__ENABLED
		])
	override isAllowed() {
		super.isAllowed()
	}

}
