package sr5e1_power.generator

import com.google.inject.Inject
import com.google.inject.Provider
import com.st.stellar.consumption.model.consumption.CoreCluster
import com.st.stellar.consumption.model.consumption.PeriphCluster
import com.st.stellar.consumption.model.consumption.SystemResource
import java.io.Closeable
import java.io.FileNotFoundException
import java.io.FileOutputStream
import java.io.IOException
import org.apache.log4j.LogManager
import org.apache.log4j.Logger
import org.apache.poi.hssf.usermodel.HSSFCellStyle
import org.apache.poi.hssf.usermodel.HSSFFont
import org.apache.poi.hssf.usermodel.HSSFSheet
import org.apache.poi.hssf.usermodel.HSSFWorkbook
import org.apache.poi.ss.usermodel.CellType
import org.apache.poi.ss.usermodel.HorizontalAlignment
import org.apache.poi.ss.usermodel.IndexedColors
import org.apache.poi.ss.usermodel.VerticalAlignment
import org.eclipse.core.resources.IFile
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.Path
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.resource.ResourceSet
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import sr5e1_power.PowerConsumption
import sr5e1_power.util.Sr5e1Helper

//import sr5e1_clk.I2S_SEL_VALUE
class PowerCodeGenerator extends AbstractGenerator {

	@Inject Provider<ResourceSet> rsp

	@Inject extension Sr5e1Helper

	static Logger logger = LogManager.getLogger(PowerCodeGenerator);

	override doGenerate(Resource r, IFileSystemAccess2 fsa, IGeneratorContext context) {

		val resourceSet = rsp.get
		val resource = resourceSet.getResource(r.URI, true)
		// Apply Excel generation
		if(resource.contents.head === null) return
		val root = resource.contents.head
		val cfg = root as PowerConsumption

		// Implements SDD_POWER_EXPORT_EXCEL
		// Excel generation
		// var fileName = "../data-gen/" + n + ".xls"
		val fileName = cfg.getGeneratedFile("xls")

		var excelFileUri = fsa.getURI(fileName.fullPath.toString, IFileSystemAccess.DEFAULT_OUTPUT)
		val file2 = ResourcesPlugin.workspace.root.getFile(new Path(excelFileUri.toPlatformString(true)))
		generateExcel(file2, cfg)
		// fsa.generateFile(resource.getURI().lastSegment + '.txt', toText(pinSettings))
/*		try {
			ResourcesPlugin.workspace.root.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor)
		} catch (IllegalStateException ise) {
			// Ignore it... workspace is closed
		}*/
	}

//	val String[] columns = #["#", "Pin identifier", "Active", "Function direction", "FunctionName", "Peripheral",
//		"Function alternate", "Pin advanced settings"]
	def generateExcel(IFile filename, PowerConsumption power) {
		_sr5e1Helper = Sr5e1Helper.instance

		rowIndex = 1
		newRow(0, "Name", power.name, "")

//		rowIndex = 1
//		newRow(0, "Specific model", power.general.MCU_model, "")
//		rowIndex++
//		newRow(0, "R(Theta JA)", power.general.r_theta_JA, "°C")
//
//		rowIndex++
//		newRow(0, "Ambiant temperature", power.general.ambiant_temperature, "°C")
//
//		rowIndex++
//		newRow(0, "V(DD_HV)", power.general.vdd_HV, "V")
//
//		rowIndex++
//		newRow(0, "V(DD_LV)", power.general.vdd_LV, "V")
//
//		rowIndex++
//		newRow(0, "Ballast", power.general.ballast.getName, "")
		rowIndex = 1
		var row = sheet.createRow(rowIndex)
		var cell = row.createCell(COLUMN_LABEL2)
		cell.cellValue = "Description"
		cell.cellStyle = formatLabel
		cell.cellType = CellType.STRING
		val description = power.general.description
		for (line : description.split("\n")) {
			rowIndex++
			row = sheet.getRow(rowIndex)
			if (row === null) {
				row = sheet.createRow(rowIndex)
			}
			cell = row.createCell(COLUMN_LABEL2)
			cell.cellValue = line
			cell.cellType = CellType.STRING
			{
				var formatUnit = workbook.createCellStyle();
				formatUnit.font = fontNoBold
				formatUnit.setAlignment(HorizontalAlignment.LEFT);
				formatUnit.setVerticalAlignment(VerticalAlignment.TOP);
				formatUnit.indention = (line.length - line.trim.length) as short
				cell.cellStyle = formatUnit
			}
		}
		rowIndex += 5
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "VDD HV", power.general.vdd_HV, "V")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "Factor", power.general.vdd_HV_factor, "%")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "Result", power.general.vdd_HV_computed, "V")
		rowIndex+=2
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "VDD HV IO", power.general.vdd_HV_IO, "V")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "Factor", power.general.vdd_HV_IO_factor, "%")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "Result", power.general.vdd_HV_IO_computed, "V")
		rowIndex+=2
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "VDD HV ADC", power.general.vdd_HV_ADC, "V")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "Factor", power.general.vdd_HV_ADC_factor, "%")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "Result", power.general.vdd_HV_ADC_computed, "V")
		rowIndex+=2
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "VDD LV", power.general.vdd_LV, "V")
		rowIndex++;
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "Factor", power.general.vdd_LV_factor, "%")
		rowIndex++;
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "Result", power.general.vdd_LV_computed, "V")

		rowIndex += 2
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "Device", power.general.device.literal, "")
		rowIndex++;
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "Junction temp.", power.general.junction_temperature, "°C")
		rowIndex++;
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "I(DD leakage)", power.general.idd_Leakage, "mA")

		rowIndex+=2
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "I(DD_HV)", power.general.idd_HV, "mA")

		rowIndex++;
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "I(DD_HV_IO)", power.general.idd_HV_IO, "mA")

		rowIndex++;
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "I(DD_HV_ADC)", power.general.idd_HV_ADC, "mA")

		rowIndex++;
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "I(DD_LV)", power.general.idd_LV, "mA")


		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "P(HV)", power.general.p_HV, "mW")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "P(HV IO)", power.general.p_HV_IO, "mW")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "P(HV ADC)", power.general.p_HV_ADC, "mW")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "P(LV)", power.general.p_LV, "mW")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "P(Leakage)", power.general.p_LV_Leakage, "mW")
		rowIndex++
		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "P(Total)", power.general.p_Total, "mW")
//
//		rowIndex++
//		newRow(0, COLUMN_LABEL2, COLUMN_VALUE2, "P(Ballast)", power.general.p_ballast, "mW")
		rowIndex = 10
		var masterBlocks = power.eContents.filter(CoreCluster)

		for (block : masterBlocks) {
			block.createRows
		}
		var peripheralBlocks = power.eContents.filter(PeriphCluster)

		rowIndex++
		newRow(0, "Peripherals", "", "")

		for (block : peripheralBlocks) {
			println("peripheral: " + block.id)
			block.createRows

		}
		// Resize all columns to fit the content size
		for (var i = 0; i < 10; i++) {
			sheet.autoSizeColumn(i);
		}
		try {
			val file = filename.getRawLocation().makeAbsolute().toFile();
			if (!file.exists()) {
				try {
					file.createNewFile();

				} catch (IOException e) {
					println(e.message)
				}
			}
			val fileOut = new FileOutputStream(file)
			workbook.write(fileOut)
			fileOut.close

		} catch (FileNotFoundException e) {
			println(e.message)
		}
	}

	dispatch def void createRows(CoreCluster cluster) {
		rowIndex++
		newRow(0, "Masters", cluster.getId, "")
		if (cluster.IDD_HV > 0) {
			rowIndex++
			newRow(1, "I(DD HV)", cluster.IDD_HV, "mA")
		}
		if (cluster.IDD_HV_IO > 0) {
			rowIndex++
			newRow(1, "I(DD HV IO)", cluster.IDD_HV_IO, "mA")
		}
		if (cluster.IDD_HV_ADC > 0) {
			rowIndex++
			newRow(1, "I(DD HV ADC)", cluster.IDD_HV_ADC, "mA")
		}
		if (cluster.IDD_LV > 0) {
			rowIndex++
			newRow(1, "I(DD LV)", cluster.IDD_LV, "mA")
		}
		val childBlocks = cluster.eContents.filter(CoreCluster)
		for (childBlock : childBlocks) {
			rowIndex++
			newRow(0, childBlock.id, "", "")
			newRow(1, "Chip mode", cluster.chipMode.getName, "")
			rowIndex++
			newRow(1, "Clock", childBlock.SYS_CLK, "MHz")
			val resources = childBlock.eContents.filter(SystemResource)
			for (sr : resources) {
				rowIndex++
				createRows(sr)
			}
		}
	}

	dispatch def void createRows(PeriphCluster cluster) {
		rowIndex++
		newRow(2, "Frequency", cluster.SYS_CLK, "MHz")
		rowIndex++
		newRow(2, "Chip mode", cluster.chipMode.getName, "")
		val resources = cluster.eContents.filter(SystemResource)
		for (sr : resources) {
			rowIndex++
			createRows(sr)
		}
	}

	dispatch def void createRows(SystemResource sr) {
		var enabledStr = ""
		if (sr.allowed) {
			enabledStr = "enabled"
		} else {
			enabledStr = "disabled"
		}
		rowIndex++
		var childDesc = sr.describe(0).replace(sr.id, "")
		newRow(1, sr.id, childDesc, enabledStr)

		if (sr.IDD_HV > 0) {
			rowIndex++
			newRow(2, "I(DD HV)", sr.IDD_HV, "mA")
		}
		if (sr.IDD_HV_IO > 0) {
			rowIndex++
			newRow(2, "I(DD HV IO)", sr.IDD_HV_IO, "mA")
		}
		if (sr.IDD_HV_ADC > 0) {
			rowIndex++
			newRow(2, "I(DD HV ADC)", sr.IDD_HV_ADC, "mA")
		}
		if (sr.IDD_LV > 0) {
			rowIndex++
			newRow(2, "I(DD LV)", sr.IDD_LV, "mA")
		}
	}

	protected def void newRow(
		int colIndex,
		int colLabel,
		int colValue,
		String label,
		String value,
		String unit
	) {
		var row = sheet.getRow(rowIndex)
		if (row === null) {
			row = sheet.createRow(rowIndex)
		}
		var cell = row.createCell(colLabel + colIndex)
		cell.cellValue = label
		cell.cellType = CellType.STRING
		cell.cellStyle = colIndex > 0 ? formatLabel : formatLabelBold

		cell = row.createCell(colValue)
		cell.cellValue = value
		cell.cellStyle = formatValue
		cell.cellType = CellType.STRING

		cell = row.createCell(colValue + 1)
		cell.cellValue = unit
		cell.cellStyle = formatUnit
	}

	protected def void newRow(
		int colIndex,
		int colLabel,
		int colValue,
		String label,
		double value,
		String unit
	) {
		var row = sheet.getRow(rowIndex)
		if (row === null) {
			row = sheet.createRow(rowIndex)
		}
		var cell = row.createCell(colLabel + colIndex)
		cell.cellValue = label
		cell.cellType = CellType.STRING
		cell.cellStyle = colIndex > 0 ? formatLabel : formatLabelBold

		cell = row.createCell(colValue)
		cell.cellValue = value
		cell.cellStyle = formatValue
		cell.cellType = CellType.NUMERIC

		cell = row.createCell(colValue + 1)
		cell.cellValue = unit
		cell.cellStyle = formatUnit
	}

	protected def void newRow(
		int colIndex,
		String label,
		double value,
		String unit
	) {
		newRow(colIndex, COLUMN_LABEL1, COLUMN_VALUE1, label, value, unit)
	}

	protected def void newRow(
		int colIndex,
		String label,
		String value,
		String unit
	) {
		newRow(colIndex, COLUMN_LABEL1, COLUMN_VALUE1, label, value, unit)
	}

	def void closeStream(Closeable stream) {
		if (stream !== null) {
			try {
				stream.close();
			} catch (IOException e) {
				// Ignore
			}
		}
	}

	static final int COLUMN_LABEL1 = 1
	static final int COLUMN_VALUE1 = 4

	static final int COLUMN_LABEL2 = 8
	static final int COLUMN_VALUE2 = 9

	HSSFWorkbook workbook = null

	HSSFSheet sheet = null

	int rowIndex = 0

	HSSFFont headerFont
	HSSFCellStyle headerCellStyle
	HSSFFont fontBold
	HSSFFont fontNoBold
	HSSFCellStyle formatValueBold
	HSSFCellStyle formatValue
	HSSFCellStyle formatLabel
	HSSFCellStyle formatUnit
	HSSFCellStyle formatLabelBold

	new() {
		workbook = new HSSFWorkbook()

		// Create a Sheet
		sheet = workbook.createSheet("PowerConfiguration")
		// Create a Font for styling header cells
		headerFont = workbook.createFont()
		headerFont.setFontHeightInPoints(Short.parseShort("12"))
		headerFont.setColor(IndexedColors.RED.getIndex())

		// Create a CellStyle with the font
		headerCellStyle = workbook.createCellStyle()
		headerCellStyle.setFont(headerFont);

		// Create a Sheet
		fontBold = workbook.createFont
		fontBold.bold = true
		fontBold.italic = false
		fontBold.fontName = HSSFFont.FONT_ARIAL
		fontBold.setFontHeightInPoints(Short.parseShort("12"))

		fontNoBold = workbook.createFont
		fontNoBold.bold = false
		fontNoBold.italic = false
		fontNoBold.fontName = HSSFFont.FONT_ARIAL
		fontNoBold.setFontHeightInPoints(Short.parseShort("12"))

		formatValue = workbook.createCellStyle();
		formatValue.font = fontNoBold
		formatValue.setAlignment(HorizontalAlignment.RIGHT);
		formatValue.setVerticalAlignment(VerticalAlignment.TOP);

		formatValueBold = workbook.createCellStyle();
		formatValueBold.font = fontBold
		formatValueBold.setAlignment(HorizontalAlignment.RIGHT);
		formatValueBold.setVerticalAlignment(VerticalAlignment.TOP);

		formatLabel = workbook.createCellStyle();
		formatLabel.font = fontNoBold
		formatLabel.setAlignment(HorizontalAlignment.LEFT);
		formatLabel.setVerticalAlignment(VerticalAlignment.TOP);

		formatLabelBold = workbook.createCellStyle();
		formatLabelBold.font = fontBold
		formatLabelBold.setAlignment(HorizontalAlignment.LEFT);
		formatLabelBold.setVerticalAlignment(VerticalAlignment.TOP);

		formatUnit = workbook.createCellStyle();
		formatUnit.font = fontNoBold
		formatUnit.setAlignment(HorizontalAlignment.LEFT);
		formatUnit.setVerticalAlignment(VerticalAlignment.TOP);
	}
}
