/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power.impl;

import com.st.stellar.consumption.model.consumption.Cluster;
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import sr5e1_power.UART;
import sr5e1_power.UARTBaudRate;
import sr5e1_power.UARTConfig;
import sr5e1_power.impl.MUARTConfigImpl;
import sr5e1_power.impl.PowerUtils;
import sr5e1_power.impl.UARTImpl;

public class UARTConfigImpl
extends MUARTConfigImpl
implements UARTConfig {
    public UARTConfigImpl() {
        this.enabled = true;
        EList _eAdapters = this.eAdapters();
        _eAdapters.add((Object)new AdapterImpl(){

            public void notifyChanged(Notification arg0) {
                UARTImpl parent = (UARTImpl)UARTConfigImpl.this.eContainer;
                if (parent != null) {
                    parent.eNotify(arg0);
                }
            }
        });
    }

    public double getIDD_HV_IO() {
        return 0.0;
    }

    public double getIDD_HV() {
        return 0.0;
    }

    public double getIDD_HV_ADC() {
        return 0.0;
    }

    public double getIDD_LV() {
        double _xblockexpression = 0.0;
        Cluster cluster = ConsumptionHelper.getCluster((EObject)this);
        if (cluster == null) {
            return 0.0;
        }
        boolean _isAllowed = this.isAllowed();
        if (_isAllowed) {
            UART parent = (UART)this.eContainer;
            UARTBaudRate baudRate = this.baudRate;
            if (baudRate != null) {
                switch (baudRate) {
                    case E9600_KBPS: {
                        double _multiplyFactor = parent.getMultiplyFactor();
                        double _divide = _multiplyFactor / 100.0;
                        double _multiply = 1.0 * _divide;
                        return PowerUtils.round(_multiply);
                    }
                    case E38400_KBPS: {
                        double _multiplyFactor_1 = parent.getMultiplyFactor();
                        double _divide_1 = _multiplyFactor_1 / 100.0;
                        double _multiply_1 = 2.0 * _divide_1;
                        return PowerUtils.round(_multiply_1);
                    }
                    case E921600_KBPS: {
                        double _multiplyFactor_2 = parent.getMultiplyFactor();
                        double _divide_2 = _multiplyFactor_2 / 100.0;
                        double _multiply_2 = 2.0 * _divide_2;
                        return PowerUtils.round(_multiply_2);
                    }
                }
            }
        }
        _xblockexpression = 0.0;
        return _xblockexpression;
    }

    public String describe(int indent) {
        String _xblockexpression = null;
        String _repeat = "\t".repeat(indent);
        StringBuilder result = new StringBuilder(_repeat);
        boolean _isAllowed = this.isAllowed();
        if (_isAllowed) {
            result.append(" (Factor: ");
            result.append(this.multiplyFactor);
            result.append("%, ");
            result.append("baudRate: ");
            result.append((Object)this.baudRate);
            result.append(")\n");
        }
        _xblockexpression = result.toString();
        return _xblockexpression;
    }
}

