/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power.impl;

import com.st.stellar.component.DependsOn;
import com.st.stellar.consumption.model.consumption.Cluster;
import com.st.stellar.consumption.model.consumption.MConsumptionPackage;
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import sr5e1_power.CAN;
import sr5e1_power.CANBaudRate;
import sr5e1_power.impl.MCANImpl;
import sr5e1_power.impl.PowerUtils;

public class CANImpl
extends MCANImpl
implements CAN {
    public CANImpl() {
        this.enabled = false;
        this.setIP_CLK("40");
    }

    public String describe(int indent) {
        String _xifexpression = null;
        boolean _isAllowed = this.isAllowed();
        if (_isAllowed) {
            String _xblockexpression = null;
            String _repeat = "\t".repeat(indent);
            String _plus = _repeat + this.id;
            StringBuilder result = new StringBuilder(_plus);
            result.append(" (clock: ");
            String _string = this.iP_CLK.toString();
            String _plus_1 = _string + " ";
            String _unit = ConsumptionHelper.getUnit((EStructuralFeature)MConsumptionPackage.eINSTANCE.getPeripheral_IP_CLK());
            String _plus_2 = _plus_1 + _unit;
            result.append(_plus_2);
            result.append(")\n");
            result.append(this.activeConfig.describe(indent + 1));
            _xifexpression = _xblockexpression = result.toString();
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    @DependsOn(source=10, dependencies={3, 11, 11, 4})
    public double getIDD_LV() {
        Cluster cluster = ConsumptionHelper.getCluster((EObject)this);
        if (cluster == null) {
            return 0.0;
        }
        boolean _isAllowed = this.isAllowed();
        if (_isAllowed) {
            CANBaudRate _baudRate = this.activeConfig.getBaudRate();
            if (_baudRate != null) {
                switch (_baudRate) {
                    case E1_MBPS: {
                        return PowerUtils.round(4.0 * (this.multiplyFactor / 100.0));
                    }
                    case E2_MBPS: {
                        return PowerUtils.round(5.0 * (this.multiplyFactor / 100.0));
                    }
                }
                return 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    @DependsOn(source=5, dependencies={3})
    public boolean isAllowed() {
        return super.isAllowed();
    }
}

