/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power.impl;

import com.st.stellar.consumption.model.consumption.Cluster;
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import sr5e1_power.CAN;
import sr5e1_power.CANBaudRate;
import sr5e1_power.CANConfig;
import sr5e1_power.impl.CANImpl;
import sr5e1_power.impl.MCANConfigImpl;
import sr5e1_power.impl.PowerUtils;

public class CANConfigImpl
extends MCANConfigImpl
implements CANConfig {
    public CANConfigImpl() {
        this.enabled = true;
        EList _eAdapters = this.eAdapters();
        _eAdapters.add((Object)new AdapterImpl(){

            public void notifyChanged(Notification arg0) {
                CANImpl parent = (CANImpl)CANConfigImpl.this.eContainer;
                if (parent != null) {
                    parent.eNotify(arg0);
                }
            }
        });
    }

    public double getIDD_HV() {
        return 0.0;
    }

    public double getIDD_HV_IO() {
        return 0.0;
    }

    public double getIDD_HV_ADC() {
        return 0.0;
    }

    public double getIDD_LV() {
        Cluster cluster = ConsumptionHelper.getCluster((EObject)this);
        if (cluster == null) {
            return 0.0;
        }
        boolean _isAllowed = this.isAllowed();
        if (_isAllowed) {
            CANImpl parent = (CANImpl)this.eContainer;
            CANBaudRate baudRate = this.baudRate;
            if (baudRate != null) {
                switch (baudRate) {
                    case E1_MBPS: {
                        double _multiplyFactor = parent.getMultiplyFactor();
                        double _divide = _multiplyFactor / 100.0;
                        double _multiply = 4.0 * _divide;
                        return PowerUtils.round(_multiply);
                    }
                    case E2_MBPS: {
                        double _multiplyFactor_1 = parent.getMultiplyFactor();
                        double _divide_1 = _multiplyFactor_1 / 100.0;
                        double _multiply_1 = 5.0 * _divide_1;
                        return PowerUtils.round(_multiply_1);
                    }
                }
                return 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    public String describe(int indent) {
        String _xblockexpression = null;
        String _repeat = "\t".repeat(indent);
        StringBuilder result = new StringBuilder(_repeat);
        boolean _isAllowed = this.isAllowed();
        if (_isAllowed) {
            result.append(" (Factor: ");
            result.append(((CAN)this.eContainer).getMultiplyFactor());
            result.append("%, ");
            result.append("baudRate: ");
            result.append((Object)this.baudRate);
            result.append(", config: ");
            result.append((Object)this.config);
            result.append(")\n");
        }
        _xblockexpression = result.toString();
        return _xblockexpression;
    }
}

