/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.consumption.model.consumption.CoreCluster;
import com.st.stellar.consumption.model.consumption.PeriphCluster;
import com.st.stellar.consumption.model.consumption.SystemResource;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import sr5e1_power.PowerConsumption;
import sr5e1_power.util.Sr5e1Helper;

public class PowerCodeGenerator
extends AbstractGenerator {
    @Inject
    private Provider<ResourceSet> rsp;
    @Inject
    @Extension
    private Sr5e1Helper _sr5e1Helper;
    private static Logger logger = LogManager.getLogger(PowerCodeGenerator.class);
    private static final int COLUMN_LABEL1 = 1;
    private static final int COLUMN_VALUE1 = 4;
    private static final int COLUMN_LABEL2 = 8;
    private static final int COLUMN_VALUE2 = 9;
    private HSSFWorkbook workbook = null;
    private HSSFSheet sheet = null;
    private int rowIndex = 0;
    private HSSFFont headerFont;
    private HSSFCellStyle headerCellStyle;
    private HSSFFont fontBold;
    private HSSFFont fontNoBold;
    private HSSFCellStyle formatValueBold;
    private HSSFCellStyle formatValue;
    private HSSFCellStyle formatLabel;
    private HSSFCellStyle formatUnit;
    private HSSFCellStyle formatLabelBold;

    public void doGenerate(Resource r, IFileSystemAccess2 fsa, IGeneratorContext context) {
        boolean _tripleEquals;
        ResourceSet resourceSet = (ResourceSet)this.rsp.get();
        Resource resource = resourceSet.getResource(r.getURI(), true);
        EObject _head = (EObject)IterableExtensions.head((Iterable)resource.getContents());
        boolean bl = _tripleEquals = _head == null;
        if (_tripleEquals) {
            return;
        }
        EObject root = (EObject)IterableExtensions.head((Iterable)resource.getContents());
        PowerConsumption cfg = (PowerConsumption)root;
        IFile fileName = this._sr5e1Helper.getGeneratedFile(cfg, "xls");
        URI excelFileUri = fsa.getURI(fileName.getFullPath().toString(), "DEFAULT_OUTPUT");
        IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
        String _platformString = excelFileUri.toPlatformString(true);
        Path _path = new Path(_platformString);
        IFile file2 = _root.getFile((IPath)_path);
        this.generateExcel(file2, cfg);
    }

    public String generateExcel(IFile filename, PowerConsumption power) {
        try {
            String[] _split;
            String _xblockexpression = null;
            this._sr5e1Helper = Sr5e1Helper.instance;
            this.rowIndex = 1;
            this.newRow(0, "Name", power.getName(), "");
            this.rowIndex = 1;
            HSSFRow row = this.sheet.createRow(this.rowIndex);
            HSSFCell cell = row.createCell(8);
            cell.setCellValue("Description");
            cell.setCellStyle(this.formatLabel);
            cell.setCellType(CellType.STRING);
            String description = power.getGeneral().getDescription();
            for (String line : _split = description.split("\n")) {
                ++this.rowIndex;
                row = this.sheet.getRow(this.rowIndex);
                if (row == null) {
                    row = this.sheet.createRow(this.rowIndex);
                }
                cell = row.createCell(8);
                cell.setCellValue(line);
                cell.setCellType(CellType.STRING);
                HSSFCellStyle formatUnit = this.workbook.createCellStyle();
                formatUnit.setFont(this.fontNoBold);
                formatUnit.setAlignment(HorizontalAlignment.LEFT);
                formatUnit.setVerticalAlignment(VerticalAlignment.TOP);
                int _length = line.length();
                int _length_1 = line.trim().length();
                int _minus = _length - _length_1;
                formatUnit.setIndention((short)_minus);
                cell.setCellStyle(formatUnit);
            }
            int _rowIndex = this.rowIndex;
            this.rowIndex = _rowIndex + 5;
            this.newRow(0, 8, 9, "VDD HV", power.getGeneral().getVdd_HV(), "V");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "Factor", power.getGeneral().getVdd_HV_factor(), "%");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "Result", power.getGeneral().getVdd_HV_computed(), "V");
            int _rowIndex_1 = this.rowIndex;
            this.rowIndex = _rowIndex_1 + 2;
            this.newRow(0, 8, 9, "VDD HV IO", power.getGeneral().getVdd_HV_IO(), "V");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "Factor", power.getGeneral().getVdd_HV_IO_factor(), "%");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "Result", power.getGeneral().getVdd_HV_IO_computed(), "V");
            int _rowIndex_2 = this.rowIndex;
            this.rowIndex = _rowIndex_2 + 2;
            this.newRow(0, 8, 9, "VDD HV ADC", power.getGeneral().getVdd_HV_ADC(), "V");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "Factor", power.getGeneral().getVdd_HV_ADC_factor(), "%");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "Result", power.getGeneral().getVdd_HV_ADC_computed(), "V");
            int _rowIndex_3 = this.rowIndex;
            this.rowIndex = _rowIndex_3 + 2;
            this.newRow(0, 8, 9, "VDD LV", power.getGeneral().getVdd_LV(), "V");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "Factor", power.getGeneral().getVdd_LV_factor(), "%");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "Result", power.getGeneral().getVdd_LV_computed(), "V");
            int _rowIndex_4 = this.rowIndex;
            this.rowIndex = _rowIndex_4 + 2;
            this.newRow(0, 8, 9, "Device", power.getGeneral().getDevice().getLiteral(), "");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "Junction temp.", power.getGeneral().getJunction_temperature(), "\u00b0C");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "I(DD leakage)", power.getGeneral().getIdd_Leakage(), "mA");
            int _rowIndex_5 = this.rowIndex;
            this.rowIndex = _rowIndex_5 + 2;
            this.newRow(0, 8, 9, "I(DD_HV)", power.getGeneral().getIdd_HV(), "mA");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "I(DD_HV_IO)", power.getGeneral().getIdd_HV_IO(), "mA");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "I(DD_HV_ADC)", power.getGeneral().getIdd_HV_ADC(), "mA");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "I(DD_LV)", power.getGeneral().getIdd_LV(), "mA");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "P(HV)", power.getGeneral().getP_HV(), "mW");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "P(HV IO)", power.getGeneral().getP_HV_IO(), "mW");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "P(HV ADC)", power.getGeneral().getP_HV_ADC(), "mW");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "P(LV)", power.getGeneral().getP_LV(), "mW");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "P(Leakage)", power.getGeneral().getP_LV_Leakage(), "mW");
            ++this.rowIndex;
            this.newRow(0, 8, 9, "P(Total)", power.getGeneral().getP_Total(), "mW");
            this.rowIndex = 10;
            Iterable masterBlocks = Iterables.filter((Iterable)power.eContents(), CoreCluster.class);
            for (Object block : masterBlocks) {
                this.createRows((SystemResource)block);
            }
            Iterable peripheralBlocks = Iterables.filter((Iterable)power.eContents(), PeriphCluster.class);
            ++this.rowIndex;
            this.newRow(0, "Peripherals", "", "");
            for (PeriphCluster block_1 : peripheralBlocks) {
                String _id = block_1.getId();
                String _plus = "peripheral: " + _id;
                InputOutput.println((Object)_plus);
                this.createRows((SystemResource)block_1);
            }
            for (int i = 0; i < 10; ++i) {
                this.sheet.autoSizeColumn(i);
            }
            String _xtrycatchfinallyexpression = null;
            try {
                boolean _not;
                File file = filename.getRawLocation().makeAbsolute().toFile();
                boolean _exists = file.exists();
                boolean bl = _not = !_exists;
                if (_not) {
                    try {
                        file.createNewFile();
                    }
                    catch (Throwable _t) {
                        if (_t instanceof IOException) {
                            IOException e = (IOException)_t;
                            InputOutput.println((Object)e.getMessage());
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                FileOutputStream fileOut = new FileOutputStream(file);
                this.workbook.write((OutputStream)fileOut);
                fileOut.close();
            }
            catch (Throwable _t) {
                if (_t instanceof FileNotFoundException) {
                    FileNotFoundException e = (FileNotFoundException)_t;
                    _xtrycatchfinallyexpression = (String)InputOutput.println((Object)e.getMessage());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void _createRows(CoreCluster cluster) {
        double _iDD_LV;
        boolean _greaterThan_3;
        double _iDD_HV_ADC;
        boolean _greaterThan_2;
        double _iDD_HV_IO;
        boolean _greaterThan_1;
        boolean _greaterThan;
        ++this.rowIndex;
        this.newRow(0, "Masters", cluster.getId(), "");
        double _iDD_HV = cluster.getIDD_HV();
        boolean bl = _greaterThan = _iDD_HV > 0.0;
        if (_greaterThan) {
            ++this.rowIndex;
            this.newRow(1, "I(DD HV)", cluster.getIDD_HV(), "mA");
        }
        boolean bl2 = _greaterThan_1 = (_iDD_HV_IO = cluster.getIDD_HV_IO()) > 0.0;
        if (_greaterThan_1) {
            ++this.rowIndex;
            this.newRow(1, "I(DD HV IO)", cluster.getIDD_HV_IO(), "mA");
        }
        boolean bl3 = _greaterThan_2 = (_iDD_HV_ADC = cluster.getIDD_HV_ADC()) > 0.0;
        if (_greaterThan_2) {
            ++this.rowIndex;
            this.newRow(1, "I(DD HV ADC)", cluster.getIDD_HV_ADC(), "mA");
        }
        boolean bl4 = _greaterThan_3 = (_iDD_LV = cluster.getIDD_LV()) > 0.0;
        if (_greaterThan_3) {
            ++this.rowIndex;
            this.newRow(1, "I(DD LV)", cluster.getIDD_LV(), "mA");
        }
        Iterable childBlocks = Iterables.filter((Iterable)cluster.eContents(), CoreCluster.class);
        for (CoreCluster childBlock : childBlocks) {
            ++this.rowIndex;
            this.newRow(0, childBlock.getId(), "", "");
            this.newRow(1, "Chip mode", cluster.getChipMode().getName(), "");
            ++this.rowIndex;
            this.newRow(1, "Clock", childBlock.getSYS_CLK(), "MHz");
            Iterable resources = Iterables.filter((Iterable)childBlock.eContents(), SystemResource.class);
            for (SystemResource sr : resources) {
                ++this.rowIndex;
                this.createRows(sr);
            }
        }
    }

    protected void _createRows(PeriphCluster cluster) {
        ++this.rowIndex;
        this.newRow(2, "Frequency", cluster.getSYS_CLK(), "MHz");
        ++this.rowIndex;
        this.newRow(2, "Chip mode", cluster.getChipMode().getName(), "");
        Iterable resources = Iterables.filter((Iterable)cluster.eContents(), SystemResource.class);
        for (SystemResource sr : resources) {
            ++this.rowIndex;
            this.createRows(sr);
        }
    }

    protected void _createRows(SystemResource sr) {
        double _iDD_LV;
        boolean _greaterThan_3;
        double _iDD_HV_ADC;
        boolean _greaterThan_2;
        double _iDD_HV_IO;
        boolean _greaterThan_1;
        boolean _greaterThan;
        String enabledStr = "";
        boolean _isAllowed = sr.isAllowed();
        enabledStr = _isAllowed ? "enabled" : "disabled";
        ++this.rowIndex;
        String childDesc = sr.describe(0).replace(sr.getId(), "");
        this.newRow(1, sr.getId(), childDesc, enabledStr);
        double _iDD_HV = sr.getIDD_HV();
        boolean bl = _greaterThan = _iDD_HV > 0.0;
        if (_greaterThan) {
            ++this.rowIndex;
            this.newRow(2, "I(DD HV)", sr.getIDD_HV(), "mA");
        }
        boolean bl2 = _greaterThan_1 = (_iDD_HV_IO = sr.getIDD_HV_IO()) > 0.0;
        if (_greaterThan_1) {
            ++this.rowIndex;
            this.newRow(2, "I(DD HV IO)", sr.getIDD_HV_IO(), "mA");
        }
        boolean bl3 = _greaterThan_2 = (_iDD_HV_ADC = sr.getIDD_HV_ADC()) > 0.0;
        if (_greaterThan_2) {
            ++this.rowIndex;
            this.newRow(2, "I(DD HV ADC)", sr.getIDD_HV_ADC(), "mA");
        }
        boolean bl4 = _greaterThan_3 = (_iDD_LV = sr.getIDD_LV()) > 0.0;
        if (_greaterThan_3) {
            ++this.rowIndex;
            this.newRow(2, "I(DD LV)", sr.getIDD_LV(), "mA");
        }
    }

    protected void newRow(int colIndex, int colLabel, int colValue, String label, String value, String unit) {
        HSSFRow row = this.sheet.getRow(this.rowIndex);
        if (row == null) {
            row = this.sheet.createRow(this.rowIndex);
        }
        HSSFCell cell = row.createCell(colLabel + colIndex);
        cell.setCellValue(label);
        cell.setCellType(CellType.STRING);
        HSSFCellStyle _xifexpression = null;
        _xifexpression = colIndex > 0 ? this.formatLabel : this.formatLabelBold;
        cell.setCellStyle(_xifexpression);
        cell = row.createCell(colValue);
        cell.setCellValue(value);
        cell.setCellStyle(this.formatValue);
        cell.setCellType(CellType.STRING);
        cell = row.createCell(colValue + 1);
        cell.setCellValue(unit);
        cell.setCellStyle(this.formatUnit);
    }

    protected void newRow(int colIndex, int colLabel, int colValue, String label, double value, String unit) {
        HSSFRow row = this.sheet.getRow(this.rowIndex);
        if (row == null) {
            row = this.sheet.createRow(this.rowIndex);
        }
        HSSFCell cell = row.createCell(colLabel + colIndex);
        cell.setCellValue(label);
        cell.setCellType(CellType.STRING);
        HSSFCellStyle _xifexpression = null;
        _xifexpression = colIndex > 0 ? this.formatLabel : this.formatLabelBold;
        cell.setCellStyle(_xifexpression);
        cell = row.createCell(colValue);
        cell.setCellValue(value);
        cell.setCellStyle(this.formatValue);
        cell.setCellType(CellType.NUMERIC);
        cell = row.createCell(colValue + 1);
        cell.setCellValue(unit);
        cell.setCellStyle(this.formatUnit);
    }

    protected void newRow(int colIndex, String label, double value, String unit) {
        this.newRow(colIndex, 1, 4, label, value, unit);
    }

    protected void newRow(int colIndex, String label, String value, String unit) {
        this.newRow(colIndex, 1, 4, label, value, unit);
    }

    public void closeStream(Closeable stream) {
        block3: {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) break block3;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    public PowerCodeGenerator() {
        HSSFWorkbook _hSSFWorkbook;
        this.workbook = _hSSFWorkbook = new HSSFWorkbook();
        this.sheet = this.workbook.createSheet("PowerConfiguration");
        this.headerFont = this.workbook.createFont();
        this.headerFont.setFontHeightInPoints(Short.parseShort("12"));
        this.headerFont.setColor(IndexedColors.RED.getIndex());
        this.headerCellStyle = this.workbook.createCellStyle();
        this.headerCellStyle.setFont(this.headerFont);
        this.fontBold = this.workbook.createFont();
        this.fontBold.setBold(true);
        this.fontBold.setItalic(false);
        this.fontBold.setFontName("Arial");
        this.fontBold.setFontHeightInPoints(Short.parseShort("12"));
        this.fontNoBold = this.workbook.createFont();
        this.fontNoBold.setBold(false);
        this.fontNoBold.setItalic(false);
        this.fontNoBold.setFontName("Arial");
        this.fontNoBold.setFontHeightInPoints(Short.parseShort("12"));
        this.formatValue = this.workbook.createCellStyle();
        this.formatValue.setFont(this.fontNoBold);
        this.formatValue.setAlignment(HorizontalAlignment.RIGHT);
        this.formatValue.setVerticalAlignment(VerticalAlignment.TOP);
        this.formatValueBold = this.workbook.createCellStyle();
        this.formatValueBold.setFont(this.fontBold);
        this.formatValueBold.setAlignment(HorizontalAlignment.RIGHT);
        this.formatValueBold.setVerticalAlignment(VerticalAlignment.TOP);
        this.formatLabel = this.workbook.createCellStyle();
        this.formatLabel.setFont(this.fontNoBold);
        this.formatLabel.setAlignment(HorizontalAlignment.LEFT);
        this.formatLabel.setVerticalAlignment(VerticalAlignment.TOP);
        this.formatLabelBold = this.workbook.createCellStyle();
        this.formatLabelBold.setFont(this.fontBold);
        this.formatLabelBold.setAlignment(HorizontalAlignment.LEFT);
        this.formatLabelBold.setVerticalAlignment(VerticalAlignment.TOP);
        this.formatUnit = this.workbook.createCellStyle();
        this.formatUnit.setFont(this.fontNoBold);
        this.formatUnit.setAlignment(HorizontalAlignment.LEFT);
        this.formatUnit.setVerticalAlignment(VerticalAlignment.TOP);
    }

    @XbaseGenerated
    public void createRows(SystemResource cluster) {
        if (cluster instanceof CoreCluster) {
            this._createRows((CoreCluster)cluster);
            return;
        }
        if (cluster instanceof PeriphCluster) {
            this._createRows((PeriphCluster)cluster);
            return;
        }
        if (cluster != null) {
            this._createRows(cluster);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(cluster).toString());
    }
}

