/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DSPIBaudRate implements Enumerator
{
    E5M_HZ(0, "E5MHz", "5 MHz"),
    E10M_HZ(1, "E10MHz", "10 MHz"),
    E20M_HZ(2, "E20MHz", "20 MHz");

    public static final int E5M_HZ_VALUE = 0;
    public static final int E10M_HZ_VALUE = 1;
    public static final int E20M_HZ_VALUE = 2;
    private static final DSPIBaudRate[] VALUES_ARRAY;
    public static final List<DSPIBaudRate> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static DSPIBaudRate get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DSPIBaudRate result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DSPIBaudRate getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DSPIBaudRate result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DSPIBaudRate get(int value) {
        switch (value) {
            case 0: {
                return E5M_HZ;
            }
            case 1: {
                return E10M_HZ;
            }
            case 2: {
                return E20M_HZ;
            }
        }
        return null;
    }

    private DSPIBaudRate(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new DSPIBaudRate[]{E5M_HZ, E10M_HZ, E20M_HZ};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

