/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CANBaudRate implements Enumerator
{
    E500_KBPS(0, "E500Kbps", "500Kbps"),
    E1_MBPS(1, "E1Mbps", "1Mbps"),
    E2_MBPS(2, "E2Mbps", "2Mbps");

    public static final int E500_KBPS_VALUE = 0;
    public static final int E1_MBPS_VALUE = 1;
    public static final int E2_MBPS_VALUE = 2;
    private static final CANBaudRate[] VALUES_ARRAY;
    public static final List<CANBaudRate> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static CANBaudRate get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CANBaudRate result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CANBaudRate getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CANBaudRate result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CANBaudRate get(int value) {
        switch (value) {
            case 0: {
                return E500_KBPS;
            }
            case 1: {
                return E1_MBPS;
            }
            case 2: {
                return E2_MBPS;
            }
        }
        return null;
    }

    private CANBaudRate(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new CANBaudRate[]{E500_KBPS, E1_MBPS, E2_MBPS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

