package com.st.stellar.component.sr5e1.consumption.editor;

import com.st.stellar.component.model.ui.ComponentValidationLabelDecoratorProvider
import com.st.stellar.component.model.ui.ComponentValidationServiceLabelDecorator
import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.SystemResource
import org.eclipse.emf.common.notify.Notifier
import org.eclipse.emf.ecore.EObject
import org.eclipse.emfforms.common.Optional
import org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic.DiagnosticCache
import org.eclipse.jface.viewers.ILabelDecorator
import org.eclipse.jface.viewers.TreeViewer
import sr5e1_power.MasterBlocks
import sr5e1_power.Peripherals

class Sr5e1_powerLabelDecoratorProvider extends ComponentValidationLabelDecoratorProvider {

	new(Notifier input) {
		super(input, new DiagnosticCache(input))
	}

	override Optional<ILabelDecorator> getLabelDecorator(TreeViewer viewer) {
		decorator = new MyLabelServiceDecorator(viewer, input, cache)
		return Optional.<ILabelDecorator>of(decorator)
	}
}

class MyLabelServiceDecorator extends ComponentValidationServiceLabelDecorator {

	new(TreeViewer viewer, Notifier input, DiagnosticCache cache) {
		super(viewer, input, cache)
	}

	override String decorateText(String text, Object element) {
		return this.format(element, text);
	}

	dispatch def format(EObject object, String text) {
		return text
	}

	dispatch def format(Object object, String text) {
		return text
	}

	dispatch def format(MasterBlocks cluster, String text) {
		val allowed = cluster.isAllowed
		val iddlv = allowed && cluster.IDD_LV > 0 ? " [IDD_LV: " + String.format("%.02f", cluster.IDD_LV) + " mA]" : " "
		val iddhv = allowed && cluster.IDD_HV > 0.0 ? " [IDD_HV: " + String.format("%.02f", cluster.IDD_HV) +
				" mA]" : " "
		val iddhv_iomain = allowed && cluster.IDD_HV_IO > 0.0 ? " [IDD_HV_IO: " +
				String.format("%.02f", cluster.IDD_HV_IO) + " mA]" : " "
		val iddhv_adc = allowed && cluster.IDD_HV_ADC > 0.0 ? " [IDD_HV_ADC: " +
				String.format("%.02f", cluster.IDD_HV_ADC) + " mA]" : " "
		val conso = iddlv + iddhv + iddhv_iomain + iddhv_adc
		return cluster.id + conso
	}

	dispatch def format(Cluster cluster, String text) {
		val allowed = cluster.isAllowed
		val iddlv = allowed && cluster.IDD_LV > 0 ? " [IDD_LV: " + String.format("%.02f", cluster.IDD_LV) + " mA]" : " "
		val iddhv = allowed && cluster.IDD_HV > 0.0 ? " [IDD_HV: " + String.format("%.02f", cluster.IDD_HV) +
				" mA]" : " "
		val iddhv_iomain = allowed && cluster.IDD_HV_IO > 0.0 ? " [IDD_HV_IO: " +
				String.format("%.02f", cluster.IDD_HV_IO) + " mA]" : " "
		val iddhv_adc = allowed && cluster.IDD_HV_ADC > 0.0 ? " [IDD_HV_ADC: " +
				String.format("%.02f", cluster.IDD_HV_ADC) + " mA]" : " "
		val conso = iddlv + iddhv + iddhv_iomain + iddhv_adc
		if (allowed && !cluster.SYS_CLK.equals("Undefined")) {
			return cluster.id + " [" + cluster.SYS_CLK + " MHz]" + conso
		} else {
			return cluster.id + conso
		}
	}

	dispatch def format(SystemResource sr, String text) {
		val allowed = sr.isAllowed
		val iddlv = allowed && sr.IDD_LV > 0 ? " [IDD_LV: " + String.format("%.02f", sr.IDD_LV) + " mA]" : " "
		val iddhv = allowed && sr.IDD_HV > 0.0 ? " [IDD_HV: " + String.format("%.02f", sr.IDD_HV) + " mA]" : " "
		val iddhv_iomain = allowed && sr.IDD_HV_IO > 0.0 ? " [IDD_HV_IO: " + String.format("%.02f", sr.IDD_HV_IO) +
				" mA]" : " "
		val iddhv_adc = allowed && sr.IDD_HV_ADC > 0.0 ? " [IDD_HV_ADC: " + String.format("%.02f", sr.IDD_HV_ADC) +
				" mA]" : " "
		return sr.id + iddhv + iddlv + iddhv_iomain + iddhv_adc
	}

	dispatch def format(Peripherals periphs, String text) {
		val allowed = periphs.isAllowed
		val iddlv = allowed && periphs.IDD_LV > 0 ? " [IDD_LV: " + String.format("%.02f", periphs.IDD_LV) + " mA]" : " "
		val iddhv = allowed && periphs.IDD_HV > 0.0 ? " [IDD_HV: " + String.format("%.02f", periphs.IDD_HV) +
				" mA]" : " "
		val iddhv_iomain = allowed && periphs.IDD_HV_IO > 0.0 ? " [IDD_HV_IO: " +
				String.format("%.02f", periphs.IDD_HV_IO) + " mA]" : " "
		val iddhv_adc = allowed && periphs.IDD_HV_ADC > 0.0 ? " [IDD_HV_ADC: " +
				String.format("%.02f", periphs.IDD_HV_ADC) + " mA]" : " "
		return periphs.id + iddhv + iddlv + iddhv_iomain + iddhv_adc
	}
}
