package com.st.stellar.component.sr5e1_comparator.validation

import com.st.stellar.component.sr5e1_comparator.MSr5e1_comparatorPackage
import com.st.stellar.component.sr5e1_comparator.Sr5e1_comparator
import com.st.stellar.component.sr5e1_comparator.util.Sr5e1_comparatorValidator
import java.io.File
import java.util.Map
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.common.util.DiagnosticChain
import org.eclipse.emf.ecore.EObject
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.resources.IProject
import java.util.regex.Pattern
import com.st.stellar.component.sr5e1_comparator.impl.Sr5e1_comparatorImpl
import com.st.stellar.component.sr5e1_comparator.Configuration
import com.st.stellar.component.sr5e1_comparator.impl.MConfigurationImpl

class MySr5e1_comparatorValidator extends Sr5e1_comparatorValidator {

	public static final MySr5e1_comparatorValidator INSTANCE = new MySr5e1_comparatorValidator();

	Sr5e1_comparator currentComponent = null
	Configuration currentConfiguration = null

	static val ISSUE_CODE_PREFIX = "com.st.stellar.component.sr5e1_comparator."

	static val WRONG_NAME = ISSUE_CODE_PREFIX + 'wrongName'

	override validateConfiguration(Configuration configuration, DiagnosticChain diagnostics,
		Map<Object, Object> context) {
		currentComponent = configuration.eContainer as Sr5e1_comparator
		currentConfiguration = configuration
		super.validateConfiguration(configuration, diagnostics, context)
	}

	override validateSr5e1_comparator(Sr5e1_comparator comp, DiagnosticChain diagnostics, Map<Object, Object> context) {
		currentComponent = comp
		val res = super.validateSr5e1_comparator(comp, diagnostics, context)
		return res
	}

	override validatename_t_checkName(String nameToValidate, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_comparatorImpl
		if (parent === null) {
			return true
		}

		var res = checkName(nameToValidate, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_NAME, 0, "_UI_GenericConstraint_diagnostic",
						#["checkName", getValueLabel(MSr5e1_comparatorPackage.Literals.NAME_T, nameToValidate, context)],
						#[nameToValidate], context))
				res = false
			}
		}
		return res
	}

	override validatepath_t_checkGenPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_comparatorImpl
		if (parent === null) {
			return true
		}

		var res = checkPath(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_GENPATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_comparatorPackage.Literals.PATH_T, path, context)], #[path], context))
				res = false
			}
		}
		return res
	}

	override validatecallback_t_check_cb(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_comparatorImpl
		if (parent === null) {
			return true
		}

		var res = checkCb(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_GENPATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_comparatorPackage.Literals.PATH_T, path, context)], #[path],
						context))
				res = false
			}
		}
		return res
	}

	public static val WRONG_GENPATH = ISSUE_CODE_PREFIX + 'wrongGenPath'

	static val REGEX_NAME = Pattern.compile('''^[a-zA-Z]+[a-zA-Z0-9_]*$''')

	def checkName(String nameToValidate, DiagnosticChain chain, Map<Object, Object> map) {

		val parent = currentComponent as Sr5e1_comparatorImpl
		if (parent === null) {
			return true
		}

		val matches = REGEX_NAME.matcher(nameToValidate).matches
		if (!matches) {
			return false
		}

		// The name is syntactically correct... but may be already present in other configurations
		// Create the list of configuration names already present inside the Sr5e1 main object being validated
		// filter out current configuration (with its old name)
		var name_list = parent.configs.filter(c|c !== currentConfiguration).map[it|(it as MConfigurationImpl).name].
			toList
		if (name_list === null) {
			return true
		}

		// The new name must not be a duplicate
		val noDuplicates = (name_list.filter[it.equals(nameToValidate)].size < 1)
		noDuplicates
	}

	static val REGEX_PATH = Pattern.compile('''^[a-zA-Z0-9-_]+[a-zA-Z0-9-/\\_]*$''')

	def checkPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_PATH.matcher(location)
		var res = matcher.matches()
		res
	}

	static val REGEX_CB = Pattern.compile('''^([a-zA-Z][a-zA-Z0-9_-]*)?$''')

	def checkCb(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_CB.matcher(location)
		var res = matcher.matches()
		res
	}

}
