package com.st.stellar.component.sr5e1_comparator.impl;

import com.st.stellar.component.sr5e1_comparator.Sr5e1_comparator
import com.st.stellar.component.sr5e1_comparator.Sr5e1_comparatorPackage
import com.st.stellar.component.sr5e1_comparator.validation.MySr5e1_comparatorValidator
import org.eclipse.emf.common.util.URI
import org.eclipse.emf.ecore.EValidator

// This class overrides the generated class and will be instantiated by factory
class Sr5e1_comparatorImpl extends MSr5e1_comparatorImpl implements Sr5e1_comparator {
	
static boolean initialized = false

	static def initializeOnce() {
		if (!initialized) {
			initialized = true
		EValidator.Registry.INSTANCE.put(Sr5e1_comparatorPackage.eINSTANCE, new EValidator.Descriptor() {
			override getEValidator() {
				return MySr5e1_comparatorValidator.INSTANCE
			}
		});
		}
	}

	new() {
		initializeOnce();
	}

	def createName() {
		var chosen_name = ""
		var i = 1
		val name_list = configs.map[(it as MConfigurationImpl).name]

		chosen_name = getName + i
		var found = !name_list.contains(chosen_name)
		while (!found) {
			i++
			chosen_name = getName + i
			found = !name_list.contains(chosen_name)
		}
		chosen_name
	}

	override getName() {
		fileName(this.eResource.getURI())
	}

	private def String fileName(URI uri) {
		val len = uri.segmentCount()
		if (len == 0) {
			return null
		}

		val lastSegment = uri.segment(len - 1)
		val i = lastSegment.lastIndexOf('.')
		return i < 0 ? null : lastSegment.substring(0, i)
	}
}

