package com.st.stellar.component.sr5e1_comparator.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_comparator.Sr5e1_comparator
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

class Sr5e1_comparatorCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}

	def String generateSr5e1_comparatorcbfunc(Sr5e1_comparator component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* This callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			if (!f.callback.isNullOrEmpty() && !cbfunc_list.contains(f.callback)) {
				res = res + '''

					void «f.callback»(comp_driver_t *cdp);
				'''
				cbfunc_list.add(f.callback)
			}
		}

		return res
	}

	def String generateSr5e1_comparatorExportedFunctions(Sr5e1_comparator component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void comp_«f.name»(comp_driver_t *cdp);
			'''
		}
		header2
	}

	def String generateSr5e1_comparatorCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}

	def String generateSr5e1_comparatorHeader(Sr5e1_comparator component) {

		val error = Diagnostician.INSTANCE.validate(component)

		//val filename = component.name
		val filename = "comparator_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_comparatorCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <comp.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_comparatorcbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_comparatorExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_comparatorCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid COMPARATOR Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}


	def String generateSr5e1_comparatorCode(Sr5e1_comparator component) {

		val error = Diagnostician.INSTANCE.validate(component)

		//val filename = component.name
		val filename = "comparator_cfg"

		if (error.severity == Diagnostic.OK) {
			'''
				«generateSr5e1_comparatorCopyright()»

				#include <«filename».h>
				#include <irq.h>

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
				void comp_«f.name»(comp_driver_t *cdp) {

					/* Configure COMPARATOR driver instance.*/
					(void)comp_set_prio(cdp, «f.interrupt_priority.getName»);
					(void)comp_set_input_plus(cdp, COMP_«f.comparator»_INPUT_PLUS_«f.input_plus»);
					(void)comp_set_input_minus(cdp, COMP_«f.comparator»_INPUT_MINUS_«f.input_minus»);
					(void)comp_set_hysteresis(cdp, «f.hysteresis.getName»);
					(void)comp_set_output_polarity(cdp, «f.output_polarity.getName»);
					(void)comp_set_blank_sel(cdp, COMP_«f.comparator»_BLANKSRC_«f.blank_sel»);
					(void)comp_set_deglitch(cdp, «f.deglitch_enable.booleanValue»);
					(void)comp_set_lock(cdp, «f.lock_enable.booleanValue»);
					(void)comp_set_triggermode(cdp, «f.trigger.getName»);
					«IF(f.callback.nullOrEmpty == false)»
					(void)comp_set_cb(cdp, «f.callback»);
					«ENDIF»
				}

				«ENDFOR»

			'''
		} else {
			'''
				«generateSr5e1_comparatorCopyright()»
				#include <«filename».h>
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
