package com.st.stellar.component.sr5e1_comparator.impl;

import com.st.stellar.component.model.DerivedAttributeService
import com.st.stellar.component.sr5e1_comparator.Configuration
import com.st.stellar.component.sr5e1_comparator.Sr5e1_comparatorPackage
import org.eclipse.core.resources.IProject
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.IPath
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.command.Command
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EDataType
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.edit.command.SetCommand
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain
import org.eclipse.swt.widgets.DirectoryDialog
import org.eclipse.swt.widgets.Display

// This class overrides the generated class and will be instantiated by factory
class ConfigurationImpl extends MConfigurationImpl implements Configuration
{


	
	override getName() {
		if (name.isNullOrEmpty) {
			val parent = eContainer as Sr5e1_comparatorImpl
			name = parent.createName
		}
		name
	}
	
	static def IProject getProject(EObject model) {
		var IProject project = null
		val uri = model.eResource().getURI();
		if (!uri.isFile()) {
			project = null;
		}
		val projectName = uri.segmentsList().get(1).toString()
		project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		return project;
	}
	
	def setAttributeValue(EObject object, EAttribute attribute, String value) {
		val editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(object)

		val eClassifier = attribute.EType
		if (eClassifier instanceof EDataType) {
			val eDataType = eClassifier as EDataType
			val eFactory = eDataType.getEPackage().getEFactoryInstance()
			val newValue = eFactory.createFromString(eDataType, value)
			val Command command = SetCommand.create(editingDomain, object, attribute,
				newValue);
			// System.out.println("Attribute '" + attribute.getName() + "' set to " + newValue.toString());
			editingDomain.getCommandStack().execute(command);
		}
	}

	override availableInputPlus() {
		val INPUT_PLUS = #{
			comparator.COMP1 -> "PB2,PB3",
			comparator.COMP2 -> "PB2,PB4",
			comparator.COMP3 -> "PB7,PB8",
			comparator.COMP4 -> "PB7,PB9",
			comparator.COMP5 -> "PB12,PB13",
			comparator.COMP6 -> "PB12,PB14",
			comparator.COMP7 -> "PC3,PC4",
			comparator.COMP8 -> "PC3,PC6"
		}

		val availableValues = INPUT_PLUS.get(comparator)
		if(!availableValues.split(",").contains(input_plus)) {
			setInput_plus(availableValues.split(",").get(0))
		}
		return availableValues
		
	}

	override availableInputMinus() {
		val INPUT_MINUS = #{
			comparator.COMP1 -> "DAC1_CH1,PB1,TEST_CH,TEST_VREF",
			comparator.COMP2 -> "DAC1_CH2,PB5,TEST_CH,TEST_VREF",
			comparator.COMP3 -> "DAC2_CH1,PB13,TEST_CH,TEST_VREF",
			comparator.COMP4 -> "DAC2_CH2,PB10,TEST_CH,TEST_VREF",
			comparator.COMP5 -> "DAC3_CH1,PC4,TEST_CH,TEST_VREF",
			comparator.COMP6 -> "DAC3_CH2,PB15,TEST_CH,TEST_VREF",
			comparator.COMP7 -> "DAC4_CH1,PB8,TEST_CH,TEST_VREF",
			comparator.COMP8 -> "DAC4_CH2,PC7,TEST_CH,TEST_VREF"
		}

		val availableValues = INPUT_MINUS.get(comparator)
		if(!availableValues.split(",").contains(input_minus)) {
			setInput_minus(availableValues.split(",").get(0))
		}
		return availableValues
	}

	override availableBlankSel() {
		val BLANK_SEL = #{
			comparator.COMP1 -> "NONE,TIM1_OC5,TIM2_OC3,TIM3_OC3,TIM8_OC5,TIM3_OC4,TIM15_OC1,TIM4_OC3",
			comparator.COMP2 -> "NONE,TIM1_OC5,TIM2_OC4,TIM3_OC3,TIM8_OC5,TIM3_OC4,TIM15_OC1,TIM4_OC3",
			comparator.COMP3 -> "NONE,TIM1_OC5,TIM3_OC3,TIM2_OC4,TIM8_OC5,TIM3_OC4,TIM15_OC1,TIM4_OC3",
			comparator.COMP4 -> "NONE,TIM1_OC5,TIM3_OC3,TIM2_OC4,TIM8_OC5,TIM3_OC4,TIM15_OC1,TIM4_OC3",
			comparator.COMP5 -> "NONE,TIM2_OC3,TIM8_OC5,TIM3_OC3,TIM1_OC5,TIM3_OC4,TIM15_OC1,TIM4_OC3",
			comparator.COMP6 -> "NONE,TIM2_OC3,TIM8_OC5,TIM3_OC3,TIM1_OC5,TIM3_OC4,TIM15_OC1,TIM4_OC3",
			comparator.COMP7 -> "NONE,TIM1_OC5,TIM8_OC5,TIM3_OC3,TIM15_OC2,TIM3_OC4,TIM15_OC1,TIM4_OC3",
			comparator.COMP8 -> "NONE,TIM1_OC5,TIM8_OC5,TIM3_OC3,TIM15_OC2,TIM3_OC4,TIM15_OC1,TIM4_OC3"
		}

		val availableValues = BLANK_SEL.get(comparator)
		if(!availableValues.split(",").contains(blank_sel)) {
			setBlank_sel(availableValues.split(",").get(0))
		}
		return availableValues
	}
}
