package sr5e1_clk.impl

import com.st.stellar.component.DependsOn
import org.eclipse.emf.ecore.EValidator
import sr5e1_clk.Clock
import sr5e1_clk.Sr5e1_clkPackage
import sr5e1_clk.util.MySr5e1_clkValidator

// This class overrides the generated class and will be instantiated by factory
class ClockImpl extends MClockImpl implements Clock {

	static boolean initialized = false

	static def initializeOnce() {
		if (!initialized) {
			initialized = true
			EValidator.Registry.INSTANCE.put(Sr5e1_clkPackage.eINSTANCE, new EValidator.Descriptor() {
				override getEValidator() {
					return MySr5e1_clkValidator.INSTANCE
				}
			});
		}
	}

	new() {
		initializeOnce();
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__XOSC, dependencies=#[
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED,
		Sr5e1_clkPackage.CLOCK__XOSC_CLOCK
	])
	override getXOSC() {
		if (isXOSC_Enabled) {
			super.getXOSC()
		} else {
			0
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__SYSCLK, dependencies=#[
		Sr5e1_clkPackage.CLOCK__SW,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED,
		Sr5e1_clkPackage.CLOCK__IRCOSC,
		Sr5e1_clkPackage.CLOCK__PLL0PHI,
		Sr5e1_clkPackage.CLOCK__PLL1PHI
	])
	override getSYSCLK() {
		var res = 0L
		switch (sw) {
			case XOSC: {
				res = XOSC
			}
			case IRCOSC: {
				res = IRCOSC
			}
			case PLL0PHI: {
				res = getPLL0PHI()
			}
			case PLL1PHI: {
				res = getPLL1PHI()
			}
		}
		res
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__SYSCLK_DIV, dependencies=#[
		Sr5e1_clkPackage.CLOCK__SYSCLK,
		Sr5e1_clkPackage.CLOCK__SYSDIV
	])
	override getSYSCLK_DIV() {
		var sysclk = getSYSCLK();
		if (SYSDIV > 0) {
			sysclk / SYSDIV;
		} else {
			0
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__UART, dependencies=#[
		Sr5e1_clkPackage.CLOCK__UART_SEL,
		Sr5e1_clkPackage.CLOCK__UARTDIV,
		Sr5e1_clkPackage.CLOCK__PLL0PHI,
		Sr5e1_clkPackage.CLOCK__IRCOSC,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED,
		Sr5e1_clkPackage.CLOCK__LSI,
		Sr5e1_clkPackage.CLOCK__LSI_ENABLED
	])
	override getUART() {
		var res = 0L
		switch (uarT_SEL) {
			case PLL0PHI: {
				res = getPLL0PHI()
			}
			case IRCOSC: {
				res = IRCOSC
			}
			case XOSC: {
				res = getXOSC
			}
			case LSI: {
				res = LSI
			}
			case NOCLOCK: {
				res = 0
			}
		}
		if (UARTDIV > 0) {
			res / UARTDIV
		} else {
			0
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__I2C, dependencies=#[
		Sr5e1_clkPackage.CLOCK__I2C_SEL,
		Sr5e1_clkPackage.CLOCK__I2CDIV,
		Sr5e1_clkPackage.CLOCK__PLL0PHI,
		Sr5e1_clkPackage.CLOCK__IRCOSC,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED
	])
	override getI2C() {
		var res = 0L
		if (i2CDIV === 0) {
			res
		} else {
			switch (i2C_SEL) {
				case PLL0PHI: {
					res = getPLL0PHI()
				}
				case IRCOSC: {
					res = IRCOSC
				}
				case XOSC: {
					res = XOSC
				}
				default:
					res = 0
			}
			res / i2CDIV
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__I2S, dependencies=#[
		Sr5e1_clkPackage.CLOCK__I2S_SEL,
		Sr5e1_clkPackage.CLOCK__I2SDIV,
		Sr5e1_clkPackage.CLOCK__PLL0PHI,
		Sr5e1_clkPackage.CLOCK__IRCOSC,
		Sr5e1_clkPackage.CLOCK__I2S_CKIN,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED
	])
	override getI2S() {
		var res = 0L
		if (i2SDIV === 0) {
			res
		} else {
			switch (i2S_SEL) {
				case PLL0PHI: {
					res = getPLL0PHI()
				}
				case IRCOSC: {
					res = IRCOSC
				}
				case XOSC: {
					res = XOSC
				}
				case I2S_CKIN: {
					res = i2S_CKIN
				}
				case NOCLOCK: {
					res = 0
				}
			}
			res / getI2SDIV();
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__FDCAN, dependencies=#[
		Sr5e1_clkPackage.CLOCK__FDCAN_SEL,
		Sr5e1_clkPackage.CLOCK__FDCANDIV,
		Sr5e1_clkPackage.CLOCK__PLL0PHI,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED
	])
	override getFDCAN() {
		var res = 0L
		if (FDCANDIV === 0) {
			res
		} else {

			switch (fdcaN_SEL) {
				case PLL0PHI: {
					res = getPLL0PHI()
				}
				case XOSC: {
					res = getXOSC()
				}
				case NOCLOCK: {
					res = 0
				}
			}
			res / getFDCANDIV();
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__ADC, dependencies=#[
		Sr5e1_clkPackage.CLOCK__ADC_SEL,
		Sr5e1_clkPackage.CLOCK__ADCDIV,
		Sr5e1_clkPackage.CLOCK__PLL0PHI,
		Sr5e1_clkPackage.CLOCK__PLL1PHI,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED
	])
	override getADC() {
		var res = 0L
		switch (adC_SEL) {
			case PLL0PHI: {
				res = getPLL0PHI()
			}
			case PLL1PHI: {
				res = getPLL1PHI()
			}
			case XOSC: {
				res = XOSC
			}
			case NOCLOCK: {
				res = 0
			}
		}
		if (adcdiv == 0) {
			res
		} else {
			res / getADCDIV();
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__SDADC, dependencies=#[
		Sr5e1_clkPackage.CLOCK__SDADC_SEL,
		Sr5e1_clkPackage.CLOCK__SDADCDIV,
		Sr5e1_clkPackage.CLOCK__PLL0PHI,
		Sr5e1_clkPackage.CLOCK__PLL1PHI,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED
	])
	override getSDADC() {
		var res = 0L
		switch (sdadC_SEL) {
			case PLL0PHI: {
				res = getPLL0PHI()
			}
			case PLL1PHI: {
				res = getPLL1PHI()
			}
			case XOSC: {
				res = XOSC
			}
			case NOCLOCK: {
				res = 0
			}
		}
		if (sdadcdiv == 0) {
			res
		} else {
			res / getSDADCDIV();
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__PLL0IN, dependencies=#[
		Sr5e1_clkPackage.CLOCK__PLL0_SRC,
		Sr5e1_clkPackage.CLOCK__IRCOSC,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED
	])
	override getPLL0IN() {
		var res = 0L

		switch (pll0_SRC) {
			case XOSC: {
				res = XOSC
			}
			case IRCOSC: {
				res = IRCOSC
			}
			case NOCLOCK: {
				res = 0
			}
		}
		res
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__PLL0PFD, dependencies=#[
		Sr5e1_clkPackage.CLOCK__PLL0_PREDIV,
		Sr5e1_clkPackage.CLOCK__PLL0IN
	])
	override getPLL0PFD() {
		if (pll0_PREDIV == 0) {
			0
		} else {
			getPLL0IN() / pll0_PREDIV;
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__PLL0VCO, dependencies=#[
		Sr5e1_clkPackage.CLOCK__PLL0PFD,
		Sr5e1_clkPackage.CLOCK__PLL0_MFD
	])
	override getPLL0VCO() {
		getPLL0PFD() * 2 * pll0_MFD
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__PLL0PHI, dependencies=#[
		Sr5e1_clkPackage.CLOCK__PLL0_RFDPHI,
		Sr5e1_clkPackage.CLOCK__PLL0VCO
	])
	override getPLL0PHI() {
		if (pll0_RFDPHI == 0) {
			0
		} else {
			getPLL0VCO() / pll0_RFDPHI / 2;
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__PLL0PHI1, dependencies=#[
		Sr5e1_clkPackage.CLOCK__PLL0_RFDPHI1,
		Sr5e1_clkPackage.CLOCK__PLL0VCO
	])
	override getPLL0PHI1() {
		if (pll0_RFDPHI1 == 0) {
			0
		} else {
			getPLL0VCO() / pll0_RFDPHI1 / 2;
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__PLL1IN, dependencies=#[
		Sr5e1_clkPackage.CLOCK__PLL1_SRC,
		Sr5e1_clkPackage.CLOCK__PLL0PHI1,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED
	])
	override getPLL1IN() {
		var res = 0L
		switch (pll1_SRC) {
			case PLL0PHI1: {
				res = getPLL0PHI1()
			}
			case XOSC: {
				res = XOSC
			}
			case NOCLOCK: {
				res = 0
			}
		}
		res
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__PLL1VCO, dependencies=#[
		Sr5e1_clkPackage.CLOCK__PLL1IN,
		Sr5e1_clkPackage.CLOCK__PLL1_MFD
	])
	override getPLL1VCO() {
		getPLL1IN() * pll1_MFD
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__PLL1PHI, dependencies=#[
		Sr5e1_clkPackage.CLOCK__PLL1_RFDPHI,
		Sr5e1_clkPackage.CLOCK__PLL1VCO
	])
	override getPLL1PHI() {
		if (pll1_RFDPHI == 0) {
			0
		} else {
			getPLL1VCO() / pll1_RFDPHI / 2
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__RTC, dependencies=#[
		Sr5e1_clkPackage.CLOCK__RTC_SEL,
		Sr5e1_clkPackage.CLOCK__LSI,
		Sr5e1_clkPackage.CLOCK__LSI_ENABLED,
		Sr5e1_clkPackage.CLOCK__LSIDIV,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED
	])
	override getRTC() {
		var res = 0L
		if (LSIDIV === 0) {
			res
		} else {
			switch (rtC_SEL) {
				case LSI: {
					res = LSI / getLSIDIV()
				}
				case XOSC: {
					res = XOSC / 32
				}
				case NOCLOCK: {
					res = 0
				}
			}
			res
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__MCO, dependencies=#[
		Sr5e1_clkPackage.CLOCK__MCO_SEL,
		Sr5e1_clkPackage.CLOCK__LSI,
		Sr5e1_clkPackage.CLOCK__LSI_ENABLED,
		Sr5e1_clkPackage.CLOCK__IRCOSC,
		Sr5e1_clkPackage.CLOCK__LSIDIV,
		Sr5e1_clkPackage.CLOCK__XOSC,
		Sr5e1_clkPackage.CLOCK__XOSC_ENABLED,
		Sr5e1_clkPackage.CLOCK__PLL0PHI,
		Sr5e1_clkPackage.CLOCK__PLL1PHI,
		Sr5e1_clkPackage.CLOCK__MCODIV
	])
	override getMCO() {
		var res = 0L
		switch (mcO_SEL) {
			case LSI: {
				res = LSI
			}
			case IRCOSC: {
				res = IRCOSC
			}
			case XOSC: {
				res = XOSC
			}
			case PLL0PHI: {
				res = getPLL0PHI()
			}
			case PLL1PHI: {
				res = getPLL1PHI()
			}
			case NOCLOCK: {
				res = 0
			}
		}
		if (mcodiv == 0) {
			res
		} else {
			res / getMCODIV()
		}
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__PCLK1, dependencies=#[
		Sr5e1_clkPackage.CLOCK__SYSCLK_DIV
	])
	override getPCLK1() {
		getSYSCLK_DIV() / 4
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__PCLK2, dependencies=#[
		Sr5e1_clkPackage.CLOCK__SYSCLK_DIV
	])
	override getPCLK2() {
		getSYSCLK_DIV() / 2
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__SYSPRE, dependencies=#[
		Sr5e1_clkPackage.CLOCK__SYSDIV
	])
	override getSYSPRE() {
		sysdiv - 1
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__MCOPRE, dependencies=#[
		Sr5e1_clkPackage.CLOCK__MCODIV
	])
	override getMCOPRE() {
		mcodiv / 2
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__UARTPRE, dependencies=#[
		Sr5e1_clkPackage.CLOCK__UARTDIV
	])
	override getUARTPRE() {
		uartdiv - 1
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__I2CPRE, dependencies=#[
		Sr5e1_clkPackage.CLOCK__I2CDIV
	])
	override getI2CPRE() {
		i2CDIV - 1
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__I2SPRE, dependencies=#[
		Sr5e1_clkPackage.CLOCK__I2SDIV
	])
	override getI2SPRE() {
		i2SDIV - 1
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__FDCANPRE, dependencies=#[
		Sr5e1_clkPackage.CLOCK__FDCANDIV
	])
	override getFDCANPRE() {
		fdcandiv - 1
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__ADCPRE, dependencies=#[
		Sr5e1_clkPackage.CLOCK__ADCDIV
	])
	override getADCPRE() {
		adcdiv / 2
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__SDADCPRE, dependencies=#[
		Sr5e1_clkPackage.CLOCK__SDADCDIV
	])
	override getSDADCPRE() {
		sdadcdiv / 2
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__LSIPRE, dependencies=#[
		Sr5e1_clkPackage.CLOCK__LSI_ENABLED,
		Sr5e1_clkPackage.CLOCK__LSIDIV,
		Sr5e1_clkPackage.CLOCK__LSICLK,
		Sr5e1_clkPackage.CLOCK__LSI
	])
	override getLSIPRE() {
		lsidiv / 2
	}

	@DependsOn(source=Sr5e1_clkPackage.CLOCK__LSI, dependencies=#[
		Sr5e1_clkPackage.CLOCK__LSI_ENABLED,
		Sr5e1_clkPackage.CLOCK__LSICLK
	])
	override getLSI() {
		if (lsI_Enabled) {
			super.getLSICLK()
		} else {
			0
		}
	}
}
