package sr5e1_clk.generator

import com.google.inject.Inject
import com.google.inject.Provider
import java.io.IOException
import java.net.MalformedURLException
import java.net.URL
import java.util.Locale
import org.apache.log4j.LogManager
import org.apache.log4j.Logger
import org.eclipse.core.resources.IResource
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.FileLocator
import org.eclipse.core.runtime.NullProgressMonitor
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.resource.ResourceSet
import org.eclipse.osgi.util.NLS
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import sr5e1_clk.Clock
import sr5e1_clk.I2S_SEL_VALUE

class ClockCodeGenerator extends AbstractGenerator {

	@Inject Provider<ResourceSet> rsp

	static Logger logger = LogManager.getLogger(ClockCodeGenerator);

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {

		val resourceSet = rsp.get
		val r = resourceSet.getResource(input.URI, true)
		if(r.contents.empty) return
		val cmp = r.contents.head as Clock
		val html = generateHTML(cmp, false)
		fsa.generateFile("../code-gen/clock.html", html)
		val config = generateClockConfig(cmp)
		fsa.generateFile("../code-gen/clock_cfg.h", config)

		try {
			ResourcesPlugin.workspace.root.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor)
		} catch (IllegalStateException ise) {
			// Ignore it... workspace is closed
		}
	}

	static final String WIZARD_INTERACTION_JS = "platform:/plugin/com.st.stellar.wizard.engine/scripts/wizardInteraction.js"; // $NON-NLS-1$
	static final String WIZARD_ENGINE_JS = "platform:/plugin/com.st.stellar.wizard.engine/scripts/wizardEngine.js"; // $NON-NLS-1$

	def String generateHTML(Clock clock, boolean generateDynamicCode) {
		var URL url = null
		var decoded = true
		if (decoded) {

			'''<!DOCTYPE HTML>
		 		<html lang="en">
		 		
		 		  <head>
		 		  	<meta charset="UTF-8" />
		 		  	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
		 		  	<meta http-equiv="X-UA-Compatible" content="ie=edge" />
		 		    <title>Wizard for «clock.eResource.URI.fileExtension»</title>   
		 		  </head>
	
		 		  <body onload="wizInit()" >
					<object id="wizard-svg" type="image/svg+xml" data="ClockTreeSR5E1.svg" ></object>
		 		  </body>
		 		  
		 		  <script>	
		 		  
		 		  var wizIntDashEmpty = function(elem) {
		 		  	var elt = svgDoc.getElementById(elem);
		 		  	if( elt == null ) {
		 		  		alert("element '"+elem+" 'not found");
		 		  	} else {
		 		  		elt.style.setProperty('stroke-opacity', "0", null);
		 		  	}
		 		  }
		 		  var wizIntDashDisable = function(elem) {
		 		  	var elt = svgDoc.getElementById(elem);
		 		  	elt.style.setProperty("stroke-dasharray", "none", null);
		 		  	elt.style.setProperty('stroke-opacity', "1", null);
		 		  }
		 		  
		 		  var wizIntDashEnable = function(elem) {
		 		  	var elt = svgDoc.getElementById(elem);
		 		  	elt.style.setProperty("stroke-dasharray", "2, 3", null);
		 		  }
		 		  
		 		  var wizIntSimpleToolTip = function(rectId,msg) {
		 		  	if( rectId) {
		 		  		var rectObj = svgDoc.getElementById(rectId);
		 		  		if( rectObj ) {
		 		  			//wizIntChangeColor(rectId,"#ffffff");
		 		  
		 		  			rectObj.onmouseover = function(evt) {
		 		  				wizEngDisplayTooltip(evt,msg);
		 		  			};
		 		  			rectObj.onmouseout = function(evt) {
		 		  				wizEngDisplayTooltip(evt,'');
		 		  			};
		 		  		} else {
		 		  			alert(rectId+"does not exist in svg file");
		 		  		}
		 		  	}
		 		  }
		 		  
		 		  var wizEngDisplayTooltip = function(event,arg) {
		 		  }

  					var svg = document.getElementById("wizard-svg");
  					var svgDoc = svg.contentDocument;
  					
  					var wizIntColorArrow = function(arrow,color){
  						var elt = svgDoc.getElementById(arrow);
  						elt.style.setProperty('stroke', color, null);	 
  					}
  					
var manageSelectionError = function(Value, SelA, ValA) {
	var colorError = "rgb(255, 0, 0)";
	var colorBlack = "rgb(0, 0, 0)";

	if( ValA && ValA.length > 0 && ValA[0] == '!' ) {
		
		if( ValA.substring(1) == Value) {
			var elt = svgDoc.getElementById(SelA);
			var errorValue = "wrong selection: '"+Value+"'";
			elt.style.setProperty('stroke', colorError, null);
			elt.style.setProperty("stroke-dasharray", "none", null);
			elt.style.setProperty('stroke-opacity', "1", null);
	
			elt.parentNode.onmouseover = function(evt) {
				wizEngDisplayTooltip(evt, errorValue);
			};
		
		} else {
			var elt = svgDoc.getElementById(SelA);
			elt.style.setProperty('stroke', colorBlack, null);
			elt.parentNode.onmouseover = function(evt) {
				wizEngDisplayTooltip(evt, '');
			}
		}
	} else {
		var elt = svgDoc.getElementById(SelA);
		elt.style.setProperty('stroke', colorBlack, null);
		elt.parentNode.onmouseover = function(evt) {
			wizEngDisplayTooltip(evt, '');
		}
	}
}
  					
var wizIntMUX51Selection = function(Value, SelA, SelB, SelC, SelD, SelE, ValA,
		ValB, ValC, ValD, ValE) {
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	wizIntDashEmpty(SelE);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	case ValE:
		wizIntDashDisable(SelE);
		break;
	}

	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	manageSelectionError(Value, SelE, ValE);
}

var wizIntMUX61Selection = function(Value, SelA, SelB, SelC, SelD, SelE, SelF, 
		ValA, ValB, ValC, ValD, ValE, ValF) {
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	wizIntDashEmpty(SelE);
	wizIntDashEmpty(SelF);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	case ValE:
		wizIntDashDisable(SelE);
		break;
	case ValF:
		wizIntDashDisable(SelF);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	manageSelectionError(Value, SelE, ValE);
	manageSelectionError(Value, SelF, ValF);
}

var wizIntMUX21Selection = function(Value, SelA, SelB, ValA, ValB) 
{
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
}

var wizIntMUX31Selection = function(Value, SelA, SelB, SelC, ValA,
		ValB, ValC) {
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
}

var wizIntMUX41Selection = function(Value, SelA, SelB, SelC, SelD,
		ValA, ValB, ValC, ValD) {
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
}


var wizIntMUX41SelectionEnabled = function(Value, isEnabled, rectId, SelA, SelB, SelC, SelD,
		ValA, ValB, ValC, ValD) {
	
	var colorIn = '#E8F2FE';
	var colorEnabled = '#ffffff';
	var colorDisabled = '#c8c8c8';
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	
	if( !isEnabled ) {
		wizIntChangeColor(rectId,colorDisabled);
		
	} else {
	wizIntChangeColor(rectId,colorEnabled);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	}
}

  					function wizInit() {
  					   	svg = document.getElementById("wizard-svg");
  					   	svgDoc = svg.contentDocument;
  					   	
  					   	
  					   	var _xosc = «clock.XOSC»/1000000;
  					   	var _ircosc = «clock.IRCOSC»/1000000;
  					   	var _pll0phi = «clock.PLL0PHI»/1000000;
  					   	var _pll1phi = «clock.PLL1PHI»/1000000;
  					   	var _sysclk_div = «clock.SYSCLK_DIV»/1000000;
  					   	var _sysclk = «clock.SYSCLK»/1000000;
  					   	
					   	// XOSC
 			 		   	var xosc = svgDoc.getElementById("val_xosc");
 			 		   	xosc.textContent = _xosc+" MHz";

 			 		   	// IRCOSC
 			 		   	var ircosc = svgDoc.getElementById("val_ircosc");
 			 		   	ircosc.textContent = _ircosc+" MHz";

 			 		   	//XOSC PLL0
 			 		   	var xosc = svgDoc.getElementById("val_xosc_pll0");
 			 		    xosc.textContent = _xosc+" MHz";

 			 		    //IRCOSC PLL0
 			 		   	var ircosc = svgDoc.getElementById("val_ircosc_pll0");
 			 		    ircosc.textContent = _ircosc+" MHz";

 			 		    //PLL0PHI
 			 		   	var pll0phi = svgDoc.getElementById("val_pll0phi");
 			 		    pll0phi.textContent = _pll0phi+" MHz";
  	 			 		    
 			 		    //PLL1PHI
 			 		   	var pll1phi = svgDoc.getElementById("val_pll1phi");
 			 		    pll1phi.textContent = _pll1phi+" MHz";

 			 		    //PLL0PHI1
 			 		   	var pll0phi1 = svgDoc.getElementById("val_pll0phi1");
 			 		   	var _pll0phi1 = «clock.PLL0PHI»/1000000;
 			 		    pll0phi1.textContent = _pll0phi1+" MHz";

 			 		    //SYSCLK
 			 		   	var sysclk = svgDoc.getElementById("val_sysclk");
 			 		    sysclk.textContent = _sysclk+" MHz";	

 			 		    //SYSCLK_DIV
 			 		   	var sysclk_div = svgDoc.getElementById("val_sysclk_div");
 			 		    sysclk_div.textContent = _sysclk_div+" MHz";

  						var pll0Sel = "«clock.PLL0_SRC»";
  						wizIntMUX21Selection(pll0Sel,"Mux21_pll0SelA", "Mux21_pll0SelB","XOSC","IRCOSC");

  						var pll1Sel = "«clock.PLL1_SRC»";
  						wizIntMUX21Selection(pll1Sel,"Mux21_pll1SelA", "Mux21_pll1SelB","PLL0PHI1","XOSC");

  						// SW multiplexor
  						var pcsSel = "«clock.SW»";
  						wizIntMUX41Selection(pcsSel, "Mux41_pcsSelA", "Mux41_pcsSelB", "Mux41_pcsSelC", "Mux41_pcsSelD", 'IRCOSC', 'XOSC', 'PLL0PHI', 'PLL1PHI');

  						// UART multiplexor
  						var uartSel = "«clock.UART_SEL»";
  						wizIntMUX41Selection(uartSel, "Mux41_uartSelA", "Mux41_uartSelB", "Mux41_uartSelC", "Mux41_uartSelD", 'PLL0PHI', 'IRCOSC', 'XOSC', 'LSI');

  						// UART value
 			 		   	var uart = svgDoc.getElementById("val_uart");
 			 		   	var _uart = «clock.UART»/1000000;
 			 		    uart.textContent = _uart+" MHz";

  						// I2C multiplexor
  						var i2cSel = "«clock.i2C_SEL»";
  						wizIntMUX31Selection(i2cSel, "Mux31_i2cSelA", "Mux31_i2cSelB", "Mux31_i2cSelC", 'PLL0PHI', 'IRCOSC', 'XOSC');

  						// I2C value
 			 		   	var i2c = svgDoc.getElementById("val_i2c");
 			 		   	var _i2c = «clock.i2C»/1000000;
 			 		    i2c.textContent = _i2c+" MHz";

  						// I2S multiplexor
  						var I2SSel = "«clock.i2S_SEL»"; 
  						wizIntMUX41Selection(I2SSel, "Mux41_i2sSelA", "Mux41_i2sSelB", "Mux41_i2sSelC", "Mux41_i2sSelD", 'PLL0PHI', 'IRCOSC', 'XOSC', 'I2S_CKIN');

  						// i2s value
 			 		   	var i2s = svgDoc.getElementById("val_i2s");
 			 		   	var _i2s = «clock.i2C»/1000000;
 			 		    i2s.textContent = _i2s+" MHz";

  						// FDCAN multiplexor
  						var fdcanSel = "«clock.FDCAN_SEL»"; 
  						wizIntMUX21Selection(fdcanSel, "Mux21_fdcanSelA", "Mux21_fdcanSelB", 'PLL0PHI', 'XOSC');

  						// FDCAN value
 			 		   	var fdcan = svgDoc.getElementById("val_fdcan");
 			 		   	var _fdcan = «clock.FDCAN»/1000000;
 			 		    fdcan.textContent = _fdcan+" MHz";

  						// ADC multiplexor
  						var adcSel = "«clock.ADC_SEL»";
  						wizIntMUX31Selection(adcSel, "Mux31_adcSelA", "Mux31_adcSelB", "Mux31_adcSelC", 'PLL0PHI', 'PLL1PHI', 'XOSC');

  						// ADC value
  						var adc = svgDoc.getElementById("val_adc");
 			 		   	var _adc = «clock.ADC»/1000000;
 			 		    adc.textContent = _adc+" MHz";

  						// SDADC multiplexor
  						var sdadcSel = "«clock.SDADC_SEL»";
  						wizIntMUX31Selection(sdadcSel, "Mux31_sdadcSelA", "Mux31_sdadcSelB", "Mux31_sdadcSelC", 'PLL0PHI', 'PLL1PHI', 'XOSC');

  						// SDADC value
  						var sdadc = svgDoc.getElementById("val_sdadc");
 			 		   	var _sdadc = «clock.SDADC»/1000000;
 			 		    sdadc.textContent = _sdadc+" MHz";

  						// MCO multiplexor
  						var mcoSel = "«clock.MCO_SEL»";
  						wizIntMUX51Selection(mcoSel, "Mux51_mcoSelA", "Mux51_mcoSelB", "Mux51_mcoSelC","Mux51_mcoSelD", "Mux51_mcoSelE", 'LSI', 'IRCOSC', 'XOSC', 'PLL0PHI', 'PLL1PHI');

  						// RTC multiplexor
  						var rtcSel = "«clock.RTC_SEL»"; 
  						wizIntMUX21Selection(rtcSel, "Mux21_rtcSelA", "Mux21_rtcSelB", 'LSI', 'XOSC');

  						// RTC value
  						var rtc = svgDoc.getElementById("val_rtc");
 			 		   	var _rtc = «clock.RTC»/1000000;
 			 		    rtc.textContent = _rtc+" MHz";

  						//Dividers
  						var _sysdiv = "«clock.SYSDIV»"; 
						var sysdiv = svgDoc.getElementById("val_sysdiv");
  						sysdiv.textContent = ": "+_sysdiv;

  						var _uartdiv = "«clock.UARTDIV»"; 
  						var uartdiv = svgDoc.getElementById("val_uartdiv");
  						uartdiv.textContent = ": "+_uartdiv;

  						var _i2cdiv = «clock.i2CDIV»; 
						var i2cdiv = svgDoc.getElementById("val_i2cdiv");
  						i2cdiv.textContent = ": "+_i2cdiv;

  						var _i2sdiv = «clock.i2SDIV»; 
						var i2sdiv = svgDoc.getElementById("val_i2sdiv");
  						i2sdiv.textContent = ": "+_i2sdiv;

						var _i2s = «clock.i2S»;
						var i2s = svgDoc.getElementById("val_i2s");
  						i2s.textContent = _i2s/1000000+" MHz";

						var _fdcandiv = "«clock.FDCANDIV»"; 
  						var fdcandiv = svgDoc.getElementById("val_fdcandiv");
  						fdcandiv.textContent = ": "+_fdcandiv; 						

						var _adcdiv = "«clock.ADCDIV»"; 
  						var adcdiv = svgDoc.getElementById("val_adcdiv");
  						adcdiv.textContent = ": "+_adcdiv;	

						var _sdadcdiv = "«clock.SDADCDIV»"; 
  						var sdadcdiv = svgDoc.getElementById("val_sdadcdiv");
  						sdadcdiv.textContent = ": "+_sdadcdiv;	

						var _mcodiv = "«clock.MCODIV»"; 
  						var mcodiv = svgDoc.getElementById("val_mcodiv");
  						mcodiv.textContent = ": "+_mcodiv;	

						var _lsidiv = "«clock.LSIDIV»"; 
    					var lsidiv = svgDoc.getElementById("val_lsidiv");
    					lsidiv.textContent = ": "+_lsidiv;	
  							
  						var rtcdiv = svgDoc.getElementById("val_rtcdiv");
  						rtcdiv.textContent = ": 32";
  					}

  		 			</script>
		 		  </html>
				'''
		} else {
			'''<!DOCTYPE html>
			<html>
			    <head>
			        <!-- head definitions go here -->
			    </head>
			    <body>
			        <p>Cannot load file «url»
			    </body>
			</html>
			'''
		}
	}

	def String generateClockConfig(Clock clock) {
		'''
		/****************************************************************************
		 *
		 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
		 *
		 * License terms: STMicroelectronics Proprietary in accordance with licensing
		 * terms SLA0098 at www.st.com.
		 *
		 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
		 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
		 *
		 * DO NOT EDIT: Header Automatically generated
		 *****************************************************************************/
		/**
		 * @file    clock_cfg.h
		 * @brief   SR5E1 clock subsystem configuration file.
		 *
		 * @addtogroup PLATFORM
		 * @addtogroup CLOCK
		 * @ingroup PLATFORM
		 * @{
		 */
		
		#ifndef _CLOCKCONF_H_
		#define _CLOCKCONF_H_
		
		/**
		 * @brief   Platform identifier
		 */
		#define SR5E1xxx_CLOCKCONF
		
		/**
		 * @name    Symmetric MultiProcessing mode settings
		 * @{
		 */
		#define CLOCK_CFG_SMP_MODE                  «clock.SMPMode.upper»
		/** @} */
		
		/**
		 * @name    Oscillator switches settings
		 * @{
		 */
		#define CLOCK_CFG_XOSC_ENABLED              «clock.XOSC_Enabled.upper»
		#define CLOCK_CFG_LSI_ENABLED               «clock.LSI_Enabled.upper»
		/** @} */
		
		/**
		 * @name    External Oscillator settings
		 * @{
		 */
		#define CLOCK_CFG_XOSCCLK                   «clock.XOSCClock»UL
		#define CLOCK_CFG_XOSC_BYPASS               «clock.bypass.upper»
		/** @} */
		
		/**
		 * @name    PLL settings
		 * @{
		 */
		#define CLOCK_CFG_PLL0SRC                   CLOCK_PLL0SRC_«clock.PLL0_SRC»
		#define CLOCK_CFG_PLL0MFD_VALUE             «clock.PLL0_MFD»U
		#define CLOCK_CFG_PLL0PREDIV_VALUE          «clock.PLL0_PREDIV»U
		#define CLOCK_CFG_PLL0RFDPHI_VALUE          «clock.PLL0_RFDPHI»U
		#define CLOCK_CFG_PLL0RFDPHI1_VALUE         «clock.PLL0_RFDPHI1»U
		#define CLOCK_CFG_PLL1SRC                   CLOCK_PLL1SRC_«clock.PLL1_SRC»
		#define CLOCK_CFG_PLL1MFD_VALUE             «clock.PLL1_MFD»U
		#define CLOCK_CFG_PLL1RFDPHI_VALUE          «clock.PLL1_RFDPHI»U
		/** @} */
		
		/**
		 * @name    System Clock settings
		 * @{
		 */
		#define CLOCK_CFG_SW                        CLOCK_SW_«clock.SW»
		#define CLOCK_CFG_SYSPRE_VALUE              «clock.SYSPRE»U
		/** @} */
		
		/**
		 * @name    Peripheral Clock settings
		 * @{
		 */
		#define CLOCK_CFG_UARTSEL                   CLOCK_UARTSEL_«clock.UART_SEL»
		#define CLOCK_CFG_I2CSEL                    CLOCK_I2CSEL_«clock.i2C_SEL»
		«IF (clock.getI2S_SEL == I2S_SEL_VALUE.I2S_CKIN)»
			#define CLOCK_CFG_SPISEL                    CLOCK_SPISEL_I2S_CKIN
		«ELSE»
			#define CLOCK_CFG_SPISEL                    CLOCK_SPISEL_«clock.getI2S_SEL»
		«ENDIF»
		#define CLOCK_CFG_FDCANSEL                  CLOCK_FDCANSEL_«clock.FDCAN_SEL»
		#define CLOCK_CFG_ADCSEL                    CLOCK_ADCSEL_«clock.ADC_SEL»
		#define CLOCK_CFG_SDADCSEL                  CLOCK_SDADCSEL_«clock.SDADC_SEL»
		#define CLOCK_CFG_MCOSEL                    CLOCK_MCOSEL_«clock.MCO_SEL»
		#define CLOCK_CFG_RTCSEL                    CLOCK_RTCSEL_«clock.RTC_SEL»
		#define CLOCK_CFG_UARTPRE_VALUE             «clock.UARTPRE»U
		#define CLOCK_CFG_I2CPRE_VALUE              «clock.i2CPRE»U
		#define CLOCK_CFG_SPIPRE_VALUE              «clock.i2SPRE»U
		#define CLOCK_CFG_FDCANPRE_VALUE            «clock.FDCANPRE»U
		#define CLOCK_CFG_ADCPRE_VALUE              «clock.ADCPRE»U
		#define CLOCK_CFG_SDADCPRE_VALUE            «clock.SDADCPRE»U
		#define CLOCK_CFG_MCOPRE_VALUE              «clock.MCOPRE»U
		#define CLOCK_CFG_LSIPRE_VALUE              «clock.LSIPRE»U
		
		«IF (clock.i2S_SEL == I2S_SEL_VALUE.I2S_CKIN)»
			#define CLOCK_CFG_I2S_CKIN                  «clock.i2S_CKIN»UL
		«ELSE»
			#define CLOCK_CFG_I2S_CKIN                  0UL
		«ENDIF»
		/** @} */
		
		#endif /* _CLOCKCONF_H_ */
		
		/** @} */
		'''
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
