/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_clk.impl;

import com.st.stellar.component.DependsOn;
import org.eclipse.emf.ecore.EValidator;
import sr5e1_clk.ADC_SEL_VALUE;
import sr5e1_clk.Clock;
import sr5e1_clk.FDCAN_SEL_VALUE;
import sr5e1_clk.I2C_SEL_VALUE;
import sr5e1_clk.I2S_SEL_VALUE;
import sr5e1_clk.MCO_SEL_VALUE;
import sr5e1_clk.PLL0_SEL;
import sr5e1_clk.PLL1_SEL;
import sr5e1_clk.RTC_SEL_VALUE;
import sr5e1_clk.SDADC_SEL_VALUE;
import sr5e1_clk.SW_VALUE;
import sr5e1_clk.Sr5e1_clkPackage;
import sr5e1_clk.UART_SEL_VALUE;
import sr5e1_clk.impl.MClockImpl;
import sr5e1_clk.util.MySr5e1_clkValidator;

public class ClockImpl
extends MClockImpl
implements Clock {
    private static boolean initialized = false;

    public static Object initializeOnce() {
        Object _xifexpression = null;
        if (!initialized) {
            Object _xblockexpression = null;
            initialized = true;
            _xifexpression = _xblockexpression = EValidator.Registry.INSTANCE.put((Object)Sr5e1_clkPackage.eINSTANCE, (Object)new EValidator.Descriptor(){

                public EValidator getEValidator() {
                    return MySr5e1_clkValidator.INSTANCE;
                }
            });
        }
        return _xifexpression;
    }

    public ClockImpl() {
        ClockImpl.initializeOnce();
    }

    @Override
    @DependsOn(source=9, dependencies={31, 7})
    public long getXOSC() {
        long _xifexpression = 0L;
        boolean _isXOSC_Enabled = this.isXOSC_Enabled();
        _xifexpression = _isXOSC_Enabled ? super.getXOSC() : 0L;
        return _xifexpression;
    }

    @Override
    @DependsOn(source=20, dependencies={36, 9, 31, 10, 14, 18})
    public long getSYSCLK() {
        long _xblockexpression = 0L;
        long res = 0L;
        SW_VALUE sw = this.sw;
        if (sw != null) {
            switch (sw) {
                case XOSC: {
                    res = this.getXOSC();
                    break;
                }
                case IRCOSC: {
                    res = this.getIRCOSC();
                    break;
                }
                case PLL0PHI: {
                    res = this.getPLL0PHI();
                    break;
                }
                case PLL1PHI: {
                    res = this.getPLL1PHI();
                    break;
                }
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=19, dependencies={20, 23})
    public long getSYSCLK_DIV() {
        boolean _greaterThan;
        long _xblockexpression = 0L;
        long sysclk = this.getSYSCLK();
        long _xifexpression = 0L;
        long _sYSDIV = this.getSYSDIV();
        boolean bl = _greaterThan = _sYSDIV > 0L;
        if (_greaterThan) {
            long _sYSDIV_1 = this.getSYSDIV();
            _xifexpression = sysclk / _sYSDIV_1;
        } else {
            _xifexpression = 0L;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=56, dependencies={44, 63, 14, 10, 9, 31, 57, 32})
    public long getUART() {
        boolean _greaterThan;
        long _xblockexpression = 0L;
        long res = 0L;
        UART_SEL_VALUE uarT_SEL = this.uarT_SEL;
        if (uarT_SEL != null) {
            switch (uarT_SEL) {
                case PLL0PHI: {
                    res = this.getPLL0PHI();
                    break;
                }
                case IRCOSC: {
                    res = this.getIRCOSC();
                    break;
                }
                case XOSC: {
                    res = this.getXOSC();
                    break;
                }
                case LSI: {
                    res = this.getLSI();
                    break;
                }
                case NOCLOCK: {
                    res = 0L;
                    break;
                }
            }
        }
        long _xifexpression = 0L;
        long _uARTDIV = this.getUARTDIV();
        boolean bl = _greaterThan = _uARTDIV > 0L;
        if (_greaterThan) {
            long _uARTDIV_1 = this.getUARTDIV();
            _xifexpression = res / _uARTDIV_1;
        } else {
            _xifexpression = 0L;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=55, dependencies={43, 64, 14, 10, 9, 31})
    public long getI2C() {
        long _xblockexpression = 0L;
        long res = 0L;
        long _xifexpression = 0L;
        if (this.i2CDIV == 0L) {
            _xifexpression = res;
        } else {
            long _xblockexpression_1 = 0L;
            I2C_SEL_VALUE i2C_SEL = this.i2C_SEL;
            if (i2C_SEL != null) {
                switch (i2C_SEL) {
                    case PLL0PHI: {
                        res = this.getPLL0PHI();
                        break;
                    }
                    case IRCOSC: {
                        res = this.getIRCOSC();
                        break;
                    }
                    case XOSC: {
                        res = this.getXOSC();
                        break;
                    }
                    default: {
                        res = 0L;
                        break;
                    }
                }
            } else {
                res = 0L;
            }
            _xifexpression = _xblockexpression_1 = res / this.i2CDIV;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=54, dependencies={42, 65, 14, 10, 60, 9, 31})
    public long getI2S() {
        long _xblockexpression = 0L;
        long res = 0L;
        long _xifexpression = 0L;
        if (this.i2SDIV == 0L) {
            _xifexpression = res;
        } else {
            long _xblockexpression_1 = 0L;
            I2S_SEL_VALUE i2S_SEL = this.i2S_SEL;
            if (i2S_SEL != null) {
                switch (i2S_SEL) {
                    case PLL0PHI: {
                        res = this.getPLL0PHI();
                        break;
                    }
                    case IRCOSC: {
                        res = this.getIRCOSC();
                        break;
                    }
                    case XOSC: {
                        res = this.getXOSC();
                        break;
                    }
                    case I2S_CKIN: {
                        res = this.i2S_CKIN;
                        break;
                    }
                    case NOCLOCK: {
                        res = 0L;
                        break;
                    }
                }
            }
            long _i2SDIV = this.getI2SDIV();
            _xifexpression = _xblockexpression_1 = res / _i2SDIV;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=53, dependencies={41, 66, 14, 9, 31})
    public long getFDCAN() {
        boolean _tripleEquals;
        long _xblockexpression = 0L;
        long res = 0L;
        long _xifexpression = 0L;
        long _fDCANDIV = this.getFDCANDIV();
        boolean bl = _tripleEquals = _fDCANDIV == 0L;
        if (_tripleEquals) {
            _xifexpression = res;
        } else {
            long _xblockexpression_1 = 0L;
            FDCAN_SEL_VALUE fdcaN_SEL = this.fdcaN_SEL;
            if (fdcaN_SEL != null) {
                switch (fdcaN_SEL) {
                    case PLL0PHI: {
                        res = this.getPLL0PHI();
                        break;
                    }
                    case XOSC: {
                        res = this.getXOSC();
                        break;
                    }
                    case NOCLOCK: {
                        res = 0L;
                        break;
                    }
                }
            }
            long _fDCANDIV_1 = this.getFDCANDIV();
            _xifexpression = _xblockexpression_1 = res / _fDCANDIV_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=52, dependencies={38, 67, 14, 18, 9, 31})
    public long getADC() {
        long _xblockexpression = 0L;
        long res = 0L;
        ADC_SEL_VALUE adC_SEL = this.adC_SEL;
        if (adC_SEL != null) {
            switch (adC_SEL) {
                case PLL0PHI: {
                    res = this.getPLL0PHI();
                    break;
                }
                case PLL1PHI: {
                    res = this.getPLL1PHI();
                    break;
                }
                case XOSC: {
                    res = this.getXOSC();
                    break;
                }
                case NOCLOCK: {
                    res = 0L;
                    break;
                }
            }
        }
        long _xifexpression = 0L;
        if (this.adcdiv == 0L) {
            _xifexpression = res;
        } else {
            long _aDCDIV = this.getADCDIV();
            _xifexpression = res / _aDCDIV;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=51, dependencies={37, 68, 14, 18, 9, 31})
    public long getSDADC() {
        long _xblockexpression = 0L;
        long res = 0L;
        SDADC_SEL_VALUE sdadC_SEL = this.sdadC_SEL;
        if (sdadC_SEL != null) {
            switch (sdadC_SEL) {
                case PLL0PHI: {
                    res = this.getPLL0PHI();
                    break;
                }
                case PLL1PHI: {
                    res = this.getPLL1PHI();
                    break;
                }
                case XOSC: {
                    res = this.getXOSC();
                    break;
                }
                case NOCLOCK: {
                    res = 0L;
                    break;
                }
            }
        }
        long _xifexpression = 0L;
        if (this.sdadcdiv == 0L) {
            _xifexpression = res;
        } else {
            long _sDADCDIV = this.getSDADCDIV();
            _xifexpression = res / _sDADCDIV;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=11, dependencies={21, 10, 9, 31})
    public long getPLL0IN() {
        long _xblockexpression = 0L;
        long res = 0L;
        PLL0_SEL pll0_SRC = this.pll0_SRC;
        if (pll0_SRC != null) {
            switch (pll0_SRC) {
                case XOSC: {
                    res = this.getXOSC();
                    break;
                }
                case IRCOSC: {
                    res = this.getIRCOSC();
                    break;
                }
                case NOCLOCK: {
                    res = 0L;
                    break;
                }
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=12, dependencies={26, 11})
    public long getPLL0PFD() {
        long _xifexpression = 0L;
        if (this.pll0_PREDIV == 0L) {
            _xifexpression = 0L;
        } else {
            long _pLL0IN = this.getPLL0IN();
            _xifexpression = _pLL0IN / this.pll0_PREDIV;
        }
        return _xifexpression;
    }

    @Override
    @DependsOn(source=13, dependencies={12, 27})
    public long getPLL0VCO() {
        long _pLL0PFD = this.getPLL0PFD();
        long _multiply = _pLL0PFD * 2L;
        return _multiply * this.pll0_MFD;
    }

    @Override
    @DependsOn(source=14, dependencies={25, 13})
    public long getPLL0PHI() {
        long _xifexpression = 0L;
        if (this.pll0_RFDPHI == 0L) {
            _xifexpression = 0L;
        } else {
            long _pLL0VCO = this.getPLL0VCO();
            long _divide = _pLL0VCO / this.pll0_RFDPHI;
            _xifexpression = _divide / 2L;
        }
        return _xifexpression;
    }

    @Override
    @DependsOn(source=15, dependencies={24, 13})
    public long getPLL0PHI1() {
        long _xifexpression = 0L;
        if (this.pll0_RFDPHI1 == 0L) {
            _xifexpression = 0L;
        } else {
            long _pLL0VCO = this.getPLL0VCO();
            long _divide = _pLL0VCO / this.pll0_RFDPHI1;
            _xifexpression = _divide / 2L;
        }
        return _xifexpression;
    }

    @Override
    @DependsOn(source=16, dependencies={22, 15, 9, 31})
    public long getPLL1IN() {
        long _xblockexpression = 0L;
        long res = 0L;
        PLL1_SEL pll1_SRC = this.pll1_SRC;
        if (pll1_SRC != null) {
            switch (pll1_SRC) {
                case PLL0PHI1: {
                    res = this.getPLL0PHI1();
                    break;
                }
                case XOSC: {
                    res = this.getXOSC();
                    break;
                }
                case NOCLOCK: {
                    res = 0L;
                    break;
                }
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=17, dependencies={16, 29})
    public long getPLL1VCO() {
        long _pLL1IN = this.getPLL1IN();
        return _pLL1IN * this.pll1_MFD;
    }

    @Override
    @DependsOn(source=18, dependencies={28, 17})
    public long getPLL1PHI() {
        long _xifexpression = 0L;
        if (this.pll1_RFDPHI == 0L) {
            _xifexpression = 0L;
        } else {
            long _pLL1VCO = this.getPLL1VCO();
            long _divide = _pLL1VCO / this.pll1_RFDPHI;
            _xifexpression = _divide / 2L;
        }
        return _xifexpression;
    }

    @Override
    @DependsOn(source=58, dependencies={45, 57, 32, 69, 9, 31})
    public long getRTC() {
        boolean _tripleEquals;
        long _xblockexpression = 0L;
        long res = 0L;
        long _xifexpression = 0L;
        long _lSIDIV = this.getLSIDIV();
        boolean bl = _tripleEquals = _lSIDIV == 0L;
        if (_tripleEquals) {
            _xifexpression = res;
        } else {
            long _xblockexpression_1 = 0L;
            RTC_SEL_VALUE rtC_SEL = this.rtC_SEL;
            if (rtC_SEL != null) {
                switch (rtC_SEL) {
                    case LSI: {
                        long _divide;
                        long _lSI = this.getLSI();
                        long _lSIDIV_1 = this.getLSIDIV();
                        res = _divide = _lSI / _lSIDIV_1;
                        break;
                    }
                    case XOSC: {
                        long _divide_1;
                        long _xOSC = this.getXOSC();
                        res = _divide_1 = _xOSC / 32L;
                        break;
                    }
                    case NOCLOCK: {
                        res = 0L;
                        break;
                    }
                }
            }
            _xifexpression = _xblockexpression_1 = res;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=71, dependencies={35, 57, 32, 10, 69, 9, 31, 14, 18, 70})
    public long getMCO() {
        long _xblockexpression = 0L;
        long res = 0L;
        MCO_SEL_VALUE mcO_SEL = this.mcO_SEL;
        if (mcO_SEL != null) {
            switch (mcO_SEL) {
                case LSI: {
                    res = this.getLSI();
                    break;
                }
                case IRCOSC: {
                    res = this.getIRCOSC();
                    break;
                }
                case XOSC: {
                    res = this.getXOSC();
                    break;
                }
                case PLL0PHI: {
                    res = this.getPLL0PHI();
                    break;
                }
                case PLL1PHI: {
                    res = this.getPLL1PHI();
                    break;
                }
                case NOCLOCK: {
                    res = 0L;
                    break;
                }
            }
        }
        long _xifexpression = 0L;
        if (this.mcodiv == 0L) {
            _xifexpression = res;
        } else {
            long _mCODIV = this.getMCODIV();
            _xifexpression = res / _mCODIV;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=61, dependencies={19})
    public long getPCLK1() {
        long _sYSCLK_DIV = this.getSYSCLK_DIV();
        return _sYSCLK_DIV / 4L;
    }

    @Override
    @DependsOn(source=62, dependencies={19})
    public long getPCLK2() {
        long _sYSCLK_DIV = this.getSYSCLK_DIV();
        return _sYSCLK_DIV / 2L;
    }

    @Override
    @DependsOn(source=34, dependencies={23})
    public long getSYSPRE() {
        return this.sysdiv - 1L;
    }

    @Override
    @DependsOn(source=33, dependencies={70})
    public long getMCOPRE() {
        return this.mcodiv / 2L;
    }

    @Override
    @DependsOn(source=49, dependencies={63})
    public long getUARTPRE() {
        return this.uartdiv - 1L;
    }

    @Override
    @DependsOn(source=48, dependencies={64})
    public long getI2CPRE() {
        return this.i2CDIV - 1L;
    }

    @Override
    @DependsOn(source=47, dependencies={65})
    public long getI2SPRE() {
        return this.i2SDIV - 1L;
    }

    @Override
    @DependsOn(source=46, dependencies={66})
    public long getFDCANPRE() {
        return this.fdcandiv - 1L;
    }

    @Override
    @DependsOn(source=40, dependencies={67})
    public long getADCPRE() {
        return this.adcdiv / 2L;
    }

    @Override
    @DependsOn(source=39, dependencies={68})
    public long getSDADCPRE() {
        return this.sdadcdiv / 2L;
    }

    @Override
    @DependsOn(source=50, dependencies={32, 69, 59, 57})
    public long getLSIPRE() {
        return this.lsidiv / 2L;
    }

    @Override
    @DependsOn(source=57, dependencies={32, 59})
    public long getLSI() {
        long _xifexpression = 0L;
        _xifexpression = this.lsI_Enabled ? super.getLSICLK() : 0L;
        return _xifexpression;
    }
}

