/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_clk.generator;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import sr5e1_clk.ADC_SEL_VALUE;
import sr5e1_clk.Clock;
import sr5e1_clk.FDCAN_SEL_VALUE;
import sr5e1_clk.I2C_SEL_VALUE;
import sr5e1_clk.I2S_SEL_VALUE;
import sr5e1_clk.MCO_SEL_VALUE;
import sr5e1_clk.PLL0_SEL;
import sr5e1_clk.PLL1_SEL;
import sr5e1_clk.RTC_SEL_VALUE;
import sr5e1_clk.SDADC_SEL_VALUE;
import sr5e1_clk.SW_VALUE;
import sr5e1_clk.UART_SEL_VALUE;

public class ClockCodeGenerator
extends AbstractGenerator {
    @Inject
    private Provider<ResourceSet> rsp;
    private static Logger logger = LogManager.getLogger(ClockCodeGenerator.class);
    private static final String WIZARD_INTERACTION_JS = "platform:/plugin/com.st.stellar.wizard.engine/scripts/wizardInteraction.js";
    private static final String WIZARD_ENGINE_JS = "platform:/plugin/com.st.stellar.wizard.engine/scripts/wizardEngine.js";

    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        try {
            ResourceSet resourceSet = (ResourceSet)this.rsp.get();
            Resource r = resourceSet.getResource(input.getURI(), true);
            boolean _isEmpty = r.getContents().isEmpty();
            if (_isEmpty) {
                return;
            }
            EObject _head = (EObject)IterableExtensions.head((Iterable)r.getContents());
            Clock cmp = (Clock)_head;
            String html = this.generateHTML(cmp, false);
            fsa.generateFile("../code-gen/clock.html", (CharSequence)html);
            String config = this.generateClockConfig(cmp);
            fsa.generateFile("../code-gen/clock_cfg.h", (CharSequence)config);
            try {
                IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                _root.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
            }
            catch (Throwable _t) {
                if (!(_t instanceof IllegalStateException)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String generateHTML(Clock clock, boolean generateDynamicCode) {
        String _xblockexpression = null;
        Object url = null;
        boolean decoded = true;
        String _xifexpression = null;
        if (decoded) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<!DOCTYPE HTML>");
            _builder.newLine();
            _builder.append("\t\t \t\t");
            _builder.append("<html lang=\"en\">");
            _builder.newLine();
            _builder.append("\t\t \t\t");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("<head>");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("<meta charset=\"UTF-8\" />");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("<meta http-equiv=\"X-UA-Compatible\" content=\"ie=edge\" />");
            _builder.newLine();
            _builder.append("\t\t \t\t    ");
            _builder.append("<title>Wizard for ");
            String _fileExtension = clock.eResource().getURI().fileExtension();
            _builder.append(_fileExtension, "\t\t \t\t    ");
            _builder.append("</title>   ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t \t\t  ");
            _builder.append("</head>");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("<body onload=\"wizInit()\" >");
            _builder.newLine();
            _builder.append("\t\t\t\t\t");
            _builder.append("<object id=\"wizard-svg\" type=\"image/svg+xml\" data=\"ClockTreeSR5E1.svg\" ></object>");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("</body>");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("<script>\t");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("var wizIntDashEmpty = function(elem) {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("var elt = svgDoc.getElementById(elem);");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("if( elt == null ) {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t");
            _builder.append("alert(\"element '\"+elem+\" 'not found\");");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t");
            _builder.append("elt.style.setProperty('stroke-opacity', \"0\", null);");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("var wizIntDashDisable = function(elem) {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("var elt = svgDoc.getElementById(elem);");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("elt.style.setProperty(\"stroke-dasharray\", \"none\", null);");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("elt.style.setProperty('stroke-opacity', \"1\", null);");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("var wizIntDashEnable = function(elem) {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("var elt = svgDoc.getElementById(elem);");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("elt.style.setProperty(\"stroke-dasharray\", \"2, 3\", null);");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("var wizIntSimpleToolTip = function(rectId,msg) {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("if( rectId) {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t");
            _builder.append("var rectObj = svgDoc.getElementById(rectId);");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t");
            _builder.append("if( rectObj ) {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t\t");
            _builder.append("//wizIntChangeColor(rectId,\"#ffffff\");");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t\t");
            _builder.append("rectObj.onmouseover = function(evt) {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t\t\t");
            _builder.append("wizEngDisplayTooltip(evt,msg);");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t\t");
            _builder.append("};");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t\t");
            _builder.append("rectObj.onmouseout = function(evt) {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t\t\t");
            _builder.append("wizEngDisplayTooltip(evt,'');");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t\t");
            _builder.append("};");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t\t");
            _builder.append("alert(rectId+\"does not exist in svg file\");");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t \t\t  \t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("var wizEngDisplayTooltip = function(event,arg) {");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t");
            _builder.append("var svg = document.getElementById(\"wizard-svg\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t");
            _builder.append("var svgDoc = svg.contentDocument;");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t");
            _builder.append("var wizIntColorArrow = function(arrow,color){");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var elt = svgDoc.getElementById(arrow);");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("elt.style.setProperty('stroke', color, null);\t ");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t");
            _builder.newLine();
            _builder.append("var manageSelectionError = function(Value, SelA, ValA) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("var colorError = \"rgb(255, 0, 0)\";");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("var colorBlack = \"rgb(0, 0, 0)\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if( ValA && ValA.length > 0 && ValA[0] == '!' ) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if( ValA.substring(1) == Value) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("var elt = svgDoc.getElementById(SelA);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("var errorValue = \"wrong selection: '\"+Value+\"'\";");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("elt.style.setProperty('stroke', colorError, null);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("elt.style.setProperty(\"stroke-dasharray\", \"none\", null);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("elt.style.setProperty('stroke-opacity', \"1\", null);");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("elt.parentNode.onmouseover = function(evt) {");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("wizEngDisplayTooltip(evt, errorValue);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("};");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("var elt = svgDoc.getElementById(SelA);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("elt.style.setProperty('stroke', colorBlack, null);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("elt.parentNode.onmouseover = function(evt) {");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("wizEngDisplayTooltip(evt, '');");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("var elt = svgDoc.getElementById(SelA);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("elt.style.setProperty('stroke', colorBlack, null);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("elt.parentNode.onmouseover = function(evt) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("wizEngDisplayTooltip(evt, '');");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t");
            _builder.newLine();
            _builder.append("var wizIntMUX51Selection = function(Value, SelA, SelB, SelC, SelD, SelE, ValA,");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("ValB, ValC, ValD, ValE) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelC);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelD);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelE);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("switch (Value) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValA:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelA);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValB:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelB);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValC:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelC);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValD:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelD);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValE:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelE);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelA, ValA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelB, ValB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelC, ValC);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelD, ValD);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelE, ValE);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("var wizIntMUX61Selection = function(Value, SelA, SelB, SelC, SelD, SelE, SelF, ");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("ValA, ValB, ValC, ValD, ValE, ValF) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelC);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelD);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelE);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelF);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("switch (Value) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValA:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelA);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValB:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelB);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValC:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelC);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValD:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelD);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValE:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelE);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValF:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelF);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelA, ValA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelB, ValB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelC, ValC);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelD, ValD);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelE, ValE);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelF, ValF);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("var wizIntMUX21Selection = function(Value, SelA, SelB, ValA, ValB) ");
            _builder.newLine();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("switch (Value) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValA:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelA);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValB:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelB);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelA, ValA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelB, ValB);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("var wizIntMUX31Selection = function(Value, SelA, SelB, SelC, ValA,");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("ValB, ValC) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelC);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("switch (Value) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValA:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelA);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValB:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelB);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValC:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelC);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelA, ValA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelB, ValB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelC, ValC);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("var wizIntMUX41Selection = function(Value, SelA, SelB, SelC, SelD,");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("ValA, ValB, ValC, ValD) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelC);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelD);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("switch (Value) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValA:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelA);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValB:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelB);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValC:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelC);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValD:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelD);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelA, ValA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelB, ValB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelC, ValC);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelD, ValD);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.newLine();
            _builder.append("var wizIntMUX41SelectionEnabled = function(Value, isEnabled, rectId, SelA, SelB, SelC, SelD,");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("ValA, ValB, ValC, ValD) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("var colorIn = '#E8F2FE';");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("var colorEnabled = '#ffffff';");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("var colorDisabled = '#c8c8c8';");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelC);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntDashEmpty(SelD);");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if( !isEnabled ) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntChangeColor(rectId,colorDisabled);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("wizIntChangeColor(rectId,colorEnabled);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("switch (Value) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValA:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelA);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValB:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelB);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValC:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelC);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("case ValD:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("wizIntDashDisable(SelD);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelA, ValA);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelB, ValB);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelC, ValC);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("manageSelectionError(Value, SelD, ValD);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t");
            _builder.append("function wizInit() {");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.append("svg = document.getElementById(\"wizard-svg\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.append("svgDoc = svg.contentDocument;");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.append("var _xosc = ");
            long _xOSC = clock.getXOSC();
            _builder.append((Object)_xOSC, "  \t\t\t\t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.append("var _ircosc = ");
            long _iRCOSC = clock.getIRCOSC();
            _builder.append((Object)_iRCOSC, "  \t\t\t\t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.append("var _pll0phi = ");
            long _pLL0PHI = clock.getPLL0PHI();
            _builder.append((Object)_pLL0PHI, "  \t\t\t\t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.append("var _pll1phi = ");
            long _pLL1PHI = clock.getPLL1PHI();
            _builder.append((Object)_pLL1PHI, "  \t\t\t\t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.append("var _sysclk_div = ");
            long _sYSCLK_DIV = clock.getSYSCLK_DIV();
            _builder.append((Object)_sYSCLK_DIV, "  \t\t\t\t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.append("var _sysclk = ");
            long _sYSCLK = clock.getSYSCLK();
            _builder.append((Object)_sYSCLK, "  \t\t\t\t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t   \t");
            _builder.newLine();
            _builder.append("\t\t\t\t\t   \t");
            _builder.append("// XOSC");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var xosc = svgDoc.getElementById(\"val_xosc\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("xosc.textContent = _xosc+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("// IRCOSC");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var ircosc = svgDoc.getElementById(\"val_ircosc\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("ircosc.textContent = _ircosc+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("//XOSC PLL0");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var xosc = svgDoc.getElementById(\"val_xosc_pll0\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("xosc.textContent = _xosc+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("//IRCOSC PLL0");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var ircosc = svgDoc.getElementById(\"val_ircosc_pll0\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("ircosc.textContent = _ircosc+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("//PLL0PHI");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var pll0phi = svgDoc.getElementById(\"val_pll0phi\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("pll0phi.textContent = _pll0phi+\" MHz\";");
            _builder.newLine();
            _builder.append("  \t \t\t\t \t\t    ");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("//PLL1PHI");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var pll1phi = svgDoc.getElementById(\"val_pll1phi\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("pll1phi.textContent = _pll1phi+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("//PLL0PHI1");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var pll0phi1 = svgDoc.getElementById(\"val_pll0phi1\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var _pll0phi1 = ");
            long _pLL0PHI_1 = clock.getPLL0PHI();
            _builder.append((Object)_pLL0PHI_1, " \t\t\t \t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("pll0phi1.textContent = _pll0phi1+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("//SYSCLK");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var sysclk = svgDoc.getElementById(\"val_sysclk\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("sysclk.textContent = _sysclk+\" MHz\";\t");
            _builder.newLine();
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("//SYSCLK_DIV");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var sysclk_div = svgDoc.getElementById(\"val_sysclk_div\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("sysclk_div.textContent = _sysclk_div+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var pll0Sel = \"");
            PLL0_SEL _pLL0_SRC = clock.getPLL0_SRC();
            _builder.append((Object)_pLL0_SRC, "  \t\t\t\t\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX21Selection(pll0Sel,\"Mux21_pll0SelA\", \"Mux21_pll0SelB\",\"XOSC\",\"IRCOSC\");");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var pll1Sel = \"");
            PLL1_SEL _pLL1_SRC = clock.getPLL1_SRC();
            _builder.append((Object)_pLL1_SRC, "  \t\t\t\t\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX21Selection(pll1Sel,\"Mux21_pll1SelA\", \"Mux21_pll1SelB\",\"PLL0PHI1\",\"XOSC\");");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// SW multiplexor");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var pcsSel = \"");
            SW_VALUE _sW = clock.getSW();
            _builder.append((Object)_sW, "  \t\t\t\t\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX41Selection(pcsSel, \"Mux41_pcsSelA\", \"Mux41_pcsSelB\", \"Mux41_pcsSelC\", \"Mux41_pcsSelD\", 'IRCOSC', 'XOSC', 'PLL0PHI', 'PLL1PHI');");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// UART multiplexor");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var uartSel = \"");
            UART_SEL_VALUE _uART_SEL = clock.getUART_SEL();
            _builder.append((Object)_uART_SEL, "  \t\t\t\t\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX41Selection(uartSel, \"Mux41_uartSelA\", \"Mux41_uartSelB\", \"Mux41_uartSelC\", \"Mux41_uartSelD\", 'PLL0PHI', 'IRCOSC', 'XOSC', 'LSI');");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// UART value");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var uart = svgDoc.getElementById(\"val_uart\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var _uart = ");
            long _uART = clock.getUART();
            _builder.append((Object)_uART, " \t\t\t \t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("uart.textContent = _uart+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// I2C multiplexor");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var i2cSel = \"");
            I2C_SEL_VALUE _i2C_SEL = clock.getI2C_SEL();
            _builder.append((Object)_i2C_SEL, "  \t\t\t\t\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX31Selection(i2cSel, \"Mux31_i2cSelA\", \"Mux31_i2cSelB\", \"Mux31_i2cSelC\", 'PLL0PHI', 'IRCOSC', 'XOSC');");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// I2C value");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var i2c = svgDoc.getElementById(\"val_i2c\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var _i2c = ");
            long _i2C = clock.getI2C();
            _builder.append((Object)_i2C, " \t\t\t \t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("i2c.textContent = _i2c+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// I2S multiplexor");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var I2SSel = \"");
            I2S_SEL_VALUE _i2S_SEL = clock.getI2S_SEL();
            _builder.append((Object)_i2S_SEL, "  \t\t\t\t\t\t");
            _builder.append("\"; ");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX41Selection(I2SSel, \"Mux41_i2sSelA\", \"Mux41_i2sSelB\", \"Mux41_i2sSelC\", \"Mux41_i2sSelD\", 'PLL0PHI', 'IRCOSC', 'XOSC', 'I2S_CKIN');");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// i2s value");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var i2s = svgDoc.getElementById(\"val_i2s\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var _i2s = ");
            long _i2C_1 = clock.getI2C();
            _builder.append((Object)_i2C_1, " \t\t\t \t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("i2s.textContent = _i2s+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// FDCAN multiplexor");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var fdcanSel = \"");
            FDCAN_SEL_VALUE _fDCAN_SEL = clock.getFDCAN_SEL();
            _builder.append((Object)_fDCAN_SEL, "  \t\t\t\t\t\t");
            _builder.append("\"; ");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX21Selection(fdcanSel, \"Mux21_fdcanSelA\", \"Mux21_fdcanSelB\", 'PLL0PHI', 'XOSC');");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// FDCAN value");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var fdcan = svgDoc.getElementById(\"val_fdcan\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var _fdcan = ");
            long _fDCAN = clock.getFDCAN();
            _builder.append((Object)_fDCAN, " \t\t\t \t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("fdcan.textContent = _fdcan+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// ADC multiplexor");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var adcSel = \"");
            ADC_SEL_VALUE _aDC_SEL = clock.getADC_SEL();
            _builder.append((Object)_aDC_SEL, "  \t\t\t\t\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX31Selection(adcSel, \"Mux31_adcSelA\", \"Mux31_adcSelB\", \"Mux31_adcSelC\", 'PLL0PHI', 'PLL1PHI', 'XOSC');");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// ADC value");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var adc = svgDoc.getElementById(\"val_adc\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var _adc = ");
            long _aDC = clock.getADC();
            _builder.append((Object)_aDC, " \t\t\t \t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("adc.textContent = _adc+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// SDADC multiplexor");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var sdadcSel = \"");
            SDADC_SEL_VALUE _sDADC_SEL = clock.getSDADC_SEL();
            _builder.append((Object)_sDADC_SEL, "  \t\t\t\t\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX31Selection(sdadcSel, \"Mux31_sdadcSelA\", \"Mux31_sdadcSelB\", \"Mux31_sdadcSelC\", 'PLL0PHI', 'PLL1PHI', 'XOSC');");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// SDADC value");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var sdadc = svgDoc.getElementById(\"val_sdadc\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var _sdadc = ");
            long _sDADC = clock.getSDADC();
            _builder.append((Object)_sDADC, " \t\t\t \t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("sdadc.textContent = _sdadc+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// MCO multiplexor");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var mcoSel = \"");
            MCO_SEL_VALUE _mCO_SEL = clock.getMCO_SEL();
            _builder.append((Object)_mCO_SEL, "  \t\t\t\t\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX51Selection(mcoSel, \"Mux51_mcoSelA\", \"Mux51_mcoSelB\", \"Mux51_mcoSelC\",\"Mux51_mcoSelD\", \"Mux51_mcoSelE\", 'LSI', 'IRCOSC', 'XOSC', 'PLL0PHI', 'PLL1PHI');");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// RTC multiplexor");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var rtcSel = \"");
            RTC_SEL_VALUE _rTC_SEL = clock.getRTC_SEL();
            _builder.append((Object)_rTC_SEL, "  \t\t\t\t\t\t");
            _builder.append("\"; ");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("wizIntMUX21Selection(rtcSel, \"Mux21_rtcSelA\", \"Mux21_rtcSelB\", 'LSI', 'XOSC');");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("// RTC value");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var rtc = svgDoc.getElementById(\"val_rtc\");");
            _builder.newLine();
            _builder.append(" \t\t\t \t\t   \t");
            _builder.append("var _rtc = ");
            long _rTC = clock.getRTC();
            _builder.append((Object)_rTC, " \t\t\t \t\t   \t");
            _builder.append("/1000000;");
            _builder.newLineIfNotEmpty();
            _builder.append(" \t\t\t \t\t    ");
            _builder.append("rtc.textContent = _rtc+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("//Dividers");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var _sysdiv = \"");
            long _sYSDIV = clock.getSYSDIV();
            _builder.append((Object)_sYSDIV, "  \t\t\t\t\t\t");
            _builder.append("\"; ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t");
            _builder.append("var sysdiv = svgDoc.getElementById(\"val_sysdiv\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("sysdiv.textContent = \": \"+_sysdiv;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var _uartdiv = \"");
            long _uARTDIV = clock.getUARTDIV();
            _builder.append((Object)_uARTDIV, "  \t\t\t\t\t\t");
            _builder.append("\"; ");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var uartdiv = svgDoc.getElementById(\"val_uartdiv\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("uartdiv.textContent = \": \"+_uartdiv;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var _i2cdiv = ");
            long _i2CDIV = clock.getI2CDIV();
            _builder.append((Object)_i2CDIV, "  \t\t\t\t\t\t");
            _builder.append("; ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t");
            _builder.append("var i2cdiv = svgDoc.getElementById(\"val_i2cdiv\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("i2cdiv.textContent = \": \"+_i2cdiv;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var _i2sdiv = ");
            long _i2SDIV = clock.getI2SDIV();
            _builder.append((Object)_i2SDIV, "  \t\t\t\t\t\t");
            _builder.append("; ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t");
            _builder.append("var i2sdiv = svgDoc.getElementById(\"val_i2sdiv\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("i2sdiv.textContent = \": \"+_i2sdiv;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t");
            _builder.append("var _i2s = ");
            long _i2S = clock.getI2S();
            _builder.append((Object)_i2S, "\t\t\t\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t");
            _builder.append("var i2s = svgDoc.getElementById(\"val_i2s\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("i2s.textContent = _i2s/1000000+\" MHz\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t");
            _builder.append("var _fdcandiv = \"");
            long _fDCANDIV = clock.getFDCANDIV();
            _builder.append((Object)_fDCANDIV, "\t\t\t\t\t\t");
            _builder.append("\"; ");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var fdcandiv = svgDoc.getElementById(\"val_fdcandiv\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("fdcandiv.textContent = \": \"+_fdcandiv; \t\t\t\t\t\t");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t");
            _builder.append("var _adcdiv = \"");
            long _aDCDIV = clock.getADCDIV();
            _builder.append((Object)_aDCDIV, "\t\t\t\t\t\t");
            _builder.append("\"; ");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var adcdiv = svgDoc.getElementById(\"val_adcdiv\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("adcdiv.textContent = \": \"+_adcdiv;\t");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t");
            _builder.append("var _sdadcdiv = \"");
            long _sDADCDIV = clock.getSDADCDIV();
            _builder.append((Object)_sDADCDIV, "\t\t\t\t\t\t");
            _builder.append("\"; ");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var sdadcdiv = svgDoc.getElementById(\"val_sdadcdiv\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("sdadcdiv.textContent = \": \"+_sdadcdiv;\t");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t");
            _builder.append("var _mcodiv = \"");
            long _mCODIV = clock.getMCODIV();
            _builder.append((Object)_mCODIV, "\t\t\t\t\t\t");
            _builder.append("\"; ");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var mcodiv = svgDoc.getElementById(\"val_mcodiv\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("mcodiv.textContent = \": \"+_mcodiv;\t");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t");
            _builder.append("var _lsidiv = \"");
            long _lSIDIV = clock.getLSIDIV();
            _builder.append((Object)_lSIDIV, "\t\t\t\t\t\t");
            _builder.append("\"; ");
            _builder.newLineIfNotEmpty();
            _builder.append("    \t\t\t\t\t");
            _builder.append("var lsidiv = svgDoc.getElementById(\"val_lsidiv\");");
            _builder.newLine();
            _builder.append("    \t\t\t\t\t");
            _builder.append("lsidiv.textContent = \": \"+_lsidiv;\t");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t\t");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("var rtcdiv = svgDoc.getElementById(\"val_rtcdiv\");");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t\t");
            _builder.append("rtcdiv.textContent = \": 32\";");
            _builder.newLine();
            _builder.append("  \t\t\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("  \t\t \t\t\t");
            _builder.append("</script>");
            _builder.newLine();
            _builder.append("\t\t \t\t  ");
            _builder.append("</html>");
            _builder.newLine();
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("<!DOCTYPE html>");
            _builder_1.newLine();
            _builder_1.append("\t\t\t");
            _builder_1.append("<html>");
            _builder_1.newLine();
            _builder_1.append("\t\t\t    ");
            _builder_1.append("<head>");
            _builder_1.newLine();
            _builder_1.append("\t\t\t        ");
            _builder_1.append("<!-- head definitions go here -->");
            _builder_1.newLine();
            _builder_1.append("\t\t\t    ");
            _builder_1.append("</head>");
            _builder_1.newLine();
            _builder_1.append("\t\t\t    ");
            _builder_1.append("<body>");
            _builder_1.newLine();
            _builder_1.append("\t\t\t        ");
            _builder_1.append("<p>Cannot load file ");
            _builder_1.append(url, "\t\t\t        ");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t\t    ");
            _builder_1.append("</body>");
            _builder_1.newLine();
            _builder_1.append("\t\t\t");
            _builder_1.append("</html>");
            _builder_1.newLine();
            _xifexpression = _builder_1.toString();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String generateClockConfig(Clock clock) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Copyright (c) 2023 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* DO NOT EDIT: Header Automatically generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file    clock_cfg.h");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @brief   SR5E1 clock subsystem configuration file.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @addtogroup PLATFORM");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @addtogroup CLOCK");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @ingroup PLATFORM");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @{");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifndef _CLOCKCONF_H_");
        _builder.newLine();
        _builder.append("#define _CLOCKCONF_H_");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @brief   Platform identifier");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define SR5E1xxx_CLOCKCONF");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @name    Symmetric MultiProcessing mode settings");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @{");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define CLOCK_CFG_SMP_MODE                  ");
        String _upper = this.upper(clock.isSMPMode());
        _builder.append(_upper);
        _builder.newLineIfNotEmpty();
        _builder.append("/** @} */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @name    Oscillator switches settings");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @{");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define CLOCK_CFG_XOSC_ENABLED              ");
        String _upper_1 = this.upper(clock.isXOSC_Enabled());
        _builder.append(_upper_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_LSI_ENABLED               ");
        String _upper_2 = this.upper(clock.isLSI_Enabled());
        _builder.append(_upper_2);
        _builder.newLineIfNotEmpty();
        _builder.append("/** @} */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @name    External Oscillator settings");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @{");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define CLOCK_CFG_XOSCCLK                   ");
        long _xOSCClock = clock.getXOSCClock();
        _builder.append((Object)_xOSCClock);
        _builder.append("UL");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_XOSC_BYPASS               ");
        String _upper_3 = this.upper(clock.isBypass());
        _builder.append(_upper_3);
        _builder.newLineIfNotEmpty();
        _builder.append("/** @} */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @name    PLL settings");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @{");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define CLOCK_CFG_PLL0SRC                   CLOCK_PLL0SRC_");
        PLL0_SEL _pLL0_SRC = clock.getPLL0_SRC();
        _builder.append((Object)_pLL0_SRC);
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_PLL0MFD_VALUE             ");
        long _pLL0_MFD = clock.getPLL0_MFD();
        _builder.append((Object)_pLL0_MFD);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_PLL0PREDIV_VALUE          ");
        long _pLL0_PREDIV = clock.getPLL0_PREDIV();
        _builder.append((Object)_pLL0_PREDIV);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_PLL0RFDPHI_VALUE          ");
        long _pLL0_RFDPHI = clock.getPLL0_RFDPHI();
        _builder.append((Object)_pLL0_RFDPHI);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_PLL0RFDPHI1_VALUE         ");
        long _pLL0_RFDPHI1 = clock.getPLL0_RFDPHI1();
        _builder.append((Object)_pLL0_RFDPHI1);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_PLL1SRC                   CLOCK_PLL1SRC_");
        PLL1_SEL _pLL1_SRC = clock.getPLL1_SRC();
        _builder.append((Object)_pLL1_SRC);
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_PLL1MFD_VALUE             ");
        long _pLL1_MFD = clock.getPLL1_MFD();
        _builder.append((Object)_pLL1_MFD);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_PLL1RFDPHI_VALUE          ");
        long _pLL1_RFDPHI = clock.getPLL1_RFDPHI();
        _builder.append((Object)_pLL1_RFDPHI);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("/** @} */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @name    System Clock settings");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @{");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define CLOCK_CFG_SW                        CLOCK_SW_");
        SW_VALUE _sW = clock.getSW();
        _builder.append((Object)_sW);
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_SYSPRE_VALUE              ");
        long _sYSPRE = clock.getSYSPRE();
        _builder.append((Object)_sYSPRE);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("/** @} */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @name    Peripheral Clock settings");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @{");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define CLOCK_CFG_UARTSEL                   CLOCK_UARTSEL_");
        UART_SEL_VALUE _uART_SEL = clock.getUART_SEL();
        _builder.append((Object)_uART_SEL);
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_I2CSEL                    CLOCK_I2CSEL_");
        I2C_SEL_VALUE _i2C_SEL = clock.getI2C_SEL();
        _builder.append((Object)_i2C_SEL);
        _builder.newLineIfNotEmpty();
        I2S_SEL_VALUE _i2S_SEL = clock.getI2S_SEL();
        boolean _equals = Objects.equals((Object)_i2S_SEL, (Object)I2S_SEL_VALUE.I2S_CKIN);
        if (_equals) {
            _builder.append("#define CLOCK_CFG_SPISEL                    CLOCK_SPISEL_I2S_CKIN");
            _builder.newLine();
        } else {
            _builder.append("#define CLOCK_CFG_SPISEL                    CLOCK_SPISEL_");
            I2S_SEL_VALUE _i2S_SEL_1 = clock.getI2S_SEL();
            _builder.append((Object)_i2S_SEL_1);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("#define CLOCK_CFG_FDCANSEL                  CLOCK_FDCANSEL_");
        FDCAN_SEL_VALUE _fDCAN_SEL = clock.getFDCAN_SEL();
        _builder.append((Object)_fDCAN_SEL);
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_ADCSEL                    CLOCK_ADCSEL_");
        ADC_SEL_VALUE _aDC_SEL = clock.getADC_SEL();
        _builder.append((Object)_aDC_SEL);
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_SDADCSEL                  CLOCK_SDADCSEL_");
        SDADC_SEL_VALUE _sDADC_SEL = clock.getSDADC_SEL();
        _builder.append((Object)_sDADC_SEL);
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_MCOSEL                    CLOCK_MCOSEL_");
        MCO_SEL_VALUE _mCO_SEL = clock.getMCO_SEL();
        _builder.append((Object)_mCO_SEL);
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_RTCSEL                    CLOCK_RTCSEL_");
        RTC_SEL_VALUE _rTC_SEL = clock.getRTC_SEL();
        _builder.append((Object)_rTC_SEL);
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_UARTPRE_VALUE             ");
        long _uARTPRE = clock.getUARTPRE();
        _builder.append((Object)_uARTPRE);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_I2CPRE_VALUE              ");
        long _i2CPRE = clock.getI2CPRE();
        _builder.append((Object)_i2CPRE);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_SPIPRE_VALUE              ");
        long _i2SPRE = clock.getI2SPRE();
        _builder.append((Object)_i2SPRE);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_FDCANPRE_VALUE            ");
        long _fDCANPRE = clock.getFDCANPRE();
        _builder.append((Object)_fDCANPRE);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_ADCPRE_VALUE              ");
        long _aDCPRE = clock.getADCPRE();
        _builder.append((Object)_aDCPRE);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_SDADCPRE_VALUE            ");
        long _sDADCPRE = clock.getSDADCPRE();
        _builder.append((Object)_sDADCPRE);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_MCOPRE_VALUE              ");
        long _mCOPRE = clock.getMCOPRE();
        _builder.append((Object)_mCOPRE);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.append("#define CLOCK_CFG_LSIPRE_VALUE              ");
        long _lSIPRE = clock.getLSIPRE();
        _builder.append((Object)_lSIPRE);
        _builder.append("U");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        I2S_SEL_VALUE _i2S_SEL_2 = clock.getI2S_SEL();
        boolean _equals_1 = Objects.equals((Object)_i2S_SEL_2, (Object)I2S_SEL_VALUE.I2S_CKIN);
        if (_equals_1) {
            _builder.append("#define CLOCK_CFG_I2S_CKIN                  ");
            long _i2S_CKIN = clock.getI2S_CKIN();
            _builder.append((Object)_i2S_CKIN);
            _builder.append("UL");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("#define CLOCK_CFG_I2S_CKIN                  0UL");
            _builder.newLine();
        }
        _builder.append("/** @} */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif /* _CLOCKCONF_H_ */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/** @} */");
        _builder.newLine();
        return _builder.toString();
    }

    protected String _upper(boolean arg) {
        String _xifexpression = null;
        _xifexpression = arg ? "TRUE" : "FALSE";
        return _xifexpression;
    }

    protected String _upper(String arg) {
        return arg.toUpperCase(Locale.ENGLISH);
    }

    @XbaseGenerated
    public String upper(Object arg) {
        if (arg instanceof Boolean) {
            return this._upper((Boolean)arg);
        }
        if (arg instanceof String) {
            return this._upper((String)arg);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(arg).toString());
    }
}

