function freq_conversion(a) {
	if (a>=1000000) {
		return Math.round((a/1000000)*100)/100+" MHz";
	}
	else if (a>=1000)
	{
		return Math.round((a/1000)*100)/100+" kHz";
	}
	else
	{
		return Math.round((a)*100)/100+" Hz";
	}
}

function wizInit() {
   	Wizard.svg = document.getElementById("wizard-svg");
   	Wizard.svgDoc = Wizard.svg.contentDocument;

	// LSI
  	wizIntGetPropertyValue("LSI", 'val_lsi',
		freq_conversion);
	wizIntEditPropertyValue('LSICLK', 'val_lsi', 'rect_LSI');
	wizIntSimpleToolTip('rect_LSI', "RC 1 MHz");
   	
	// XOSC
   	wizIntGetPropertyValue("XOSC", 'val_xosc',
		freq_conversion);
	wizIntEditPropertyValue('XOSCClock', 'val_xosc', 'rect_XOSC');
	wizIntSimpleToolTip('rect_XOSC', "4 - 40 MHz");

	// XOSC PLL0
   	wizIntGetPropertyValue("XOSC", 'val_xosc_pll0',
		freq_conversion);

   	// IRCOSC
   	wizIntGetPropertyValue("IRCOSC", 'val_ircosc',
		freq_conversion);
	wizIntSimpleToolTip('rect_IRCOSC', "Fixed to 16 MHz");

   	// IRCOSC PLL0
   	wizIntGetPropertyValue("IRCOSC", 'val_ircosc_pll0',
		freq_conversion);

    //PLL0PHI
    wizIntEditPropertyValue('PLL0_SRC', 'PLL0SRC_selector', 'PLL0SRC_selector');
    
	wizIntSetPropertyValue('PLL0_SRC', 'PLL0SRC_input1', 'XOSC');
	wizIntSetPropertyValue('PLL0_SRC', 'PLL0SRC_input1bis', 'XOSC');
	wizIntSetPropertyValue('PLL0_SRC', 'PLL0SRC_input2', 'IRCOSC');
	wizIntSetPropertyValue('PLL0_SRC', 'PLL0SRC_input2bis', 'IRCOSC');
	wizIntMUX21Selection('PLL0_SRC',"Mux21_pll0SelA", "Mux21_pll0SelB","XOSC","IRCOSC");

   	wizIntGetPropertyValue("PLL0PHI", 'val_pll0phi',
		freq_conversion);

    //PLL1PHI
    wizIntEditPropertyValue('PLL1_SRC', 'PLL1SRC_selector', 'PLL1SRC_selector');
    wizIntSetPropertyValue('PLL1_SRC', 'PLL1SRC_input1', 'PLL0PHI1');
    wizIntSetPropertyValue('PLL1_SRC', 'PLL1SRC_input2', 'XOSC');
	wizIntMUX21Selection('PLL1_SRC',"Mux21_pll1SelA", "Mux21_pll1SelB","PLL0PHI1","XOSC");

   	wizIntGetPropertyValue("PLL1PHI", 'val_pll1phi',
		freq_conversion);
	wizIntEditPropertyValue("PLL1 settings:PLL1_MFD,PLL1_RFDPHI", 'PLL1_rect','PLL1_rect');	
	
	//PLL0PHI1
   	wizIntGetPropertyValue("PLL0PHI1", 'val_pll0phi1',
		freq_conversion);
	wizIntEditPropertyValue("PLL0 settings:PLL0_MFD,PLL0_PREDIV,PLL0_RFDPHI,PLL0_RFDPHI1", 'PLL0_rect','PLL0_rect');	
				
	
	
	//SYSCLK
   	wizIntGetPropertyValue("SYSCLK", 'val_sysclk',
		freq_conversion);
    
    //SYSCLK_DIV
   	wizIntGetPropertyValue("SYSCLK_DIV", 'val_sysclk_div',
   		freq_conversion);  	

	
	// SW multiplexor
    wizIntEditPropertyValue('SW', 'SW_selector', 'SW_selector');
    wizIntSetPropertyValue('SW', 'PCS_input1', 'IRCOSC');
    wizIntSetPropertyValue('SW', 'PCS_input2', 'XOSC');
    wizIntSetPropertyValue('SW', 'PCS_input3', 'PLL0PHI');
    wizIntSetPropertyValue('SW', 'PCS_input4', 'PLL1PHI');
	wizIntMUX41Selection('SW', "Mux41_pcsSelA", "Mux41_pcsSelB", "Mux41_pcsSelC", "Mux41_pcsSelD", 'IRCOSC', 'XOSC', 'PLL0PHI', 'PLL1PHI');
	
	// UART multiplexor
   	wizIntEditPropertyValue('UART_SEL', 'UART_selector', 'UART_selector');
    wizIntSetPropertyValue('UART_SEL', 'UART_input1', 'PLL0PHI');
    wizIntSetPropertyValue('UART_SEL', 'UART_input2', 'IRCOSC');
    wizIntSetPropertyValue('UART_SEL', 'UART_input3', 'XOSC');
    wizIntSetPropertyValue('UART_SEL', 'UART_input4', 'LSI');
	wizIntMUX41Selection('UART_SEL', "Mux41_uartSelA", "Mux41_uartSelB", "Mux41_uartSelC", "Mux41_uartSelD", 'PLL0PHI', 'IRCOSC', 'XOSC', 'LSI');
	
	// UART value
   	wizIntGetPropertyValue("UART", 'val_uart',
   		freq_conversion);
   		
	// I2C multiplexor
    wizIntEditPropertyValue('I2C_SEL', 'I2C_selector', 'I2C_selector');
    wizIntSetPropertyValue('I2C_SEL', 'I2C_input1', 'PLL0PHI');
    wizIntSetPropertyValue('I2C_SEL', 'I2C_input2', 'IRCOSC');
    wizIntSetPropertyValue('I2C_SEL', 'I2C_input3', 'XOSC');
	wizIntMUX31Selection('I2C_SEL', "Mux31_i2cSelA", "Mux31_i2cSelB", "Mux31_i2cSelC", 'PLL0PHI', 'IRCOSC', 'XOSC');
	
	// I2C value
   	wizIntGetPropertyValue("I2C", 'val_i2c',
   		freq_conversion);  	

	// I2S multiplexor
    wizIntEditPropertyValue('I2S_SEL', 'I2S_selector', 'I2S_selector');
    wizIntSetPropertyValue('I2S_SEL', 'I2S_input1', 'PLL0PHI');
    wizIntSetPropertyValue('I2S_SEL', 'I2S_input2', 'IRCOSC');
    wizIntSetPropertyValue('I2S_SEL', 'I2S_input3', 'XOSC');
    wizIntSetPropertyValue('I2S_SEL', 'I2S_input4', 'I2S_CKIN');
	wizIntMUX41Selection('I2S_SEL', "Mux41_i2sSelA", "Mux41_i2sSelB", "Mux41_i2sSelC", "Mux41_i2sSelD", 'PLL0PHI', 'IRCOSC', 'XOSC', 'I2S_CKIN');

   	wizIntGetPropertyValue("I2S_CKIN", 'val_i2sckin',
   		freq_conversion);  	


	// i2s value
   	wizIntGetPropertyValue("I2S", 'val_i2s',
   		freq_conversion);  	
	wizIntEditPropertyValue('I2S_CKIN', 'val_i2sckin', 'rect_I2SCKIN');
	
	// FDCAN multiplexor
   	wizIntEditPropertyValue('FDCAN_SEL', 'FDCAN_selector', 'FDCAN_selector');
    wizIntSetPropertyValue('FDCAN_SEL', 'FDCAN_input1', 'PLL0PHI');
    wizIntSetPropertyValue('FDCAN_SEL', 'FDCAN_input2', 'XOSC');
	wizIntMUX21Selection('FDCAN_SEL', "Mux21_fdcanSelA", "Mux21_fdcanSelB", 'PLL0PHI', 'XOSC');

	// FDCAN value
   	wizIntGetPropertyValue("FDCAN", 'val_fdcan',
   		freq_conversion);  	

	// ADC multiplexor
	wizIntEditPropertyValue('ADC_SEL', 'ADC_selector', 'ADC_selector');
    wizIntSetPropertyValue('ADC_SEL', 'ADC_input1', 'PLL0PHI');
    wizIntSetPropertyValue('ADC_SEL', 'ADC_input2', 'PLL1PHI');
    wizIntSetPropertyValue('ADC_SEL', 'ADC_input3', 'XOSC');
	wizIntMUX31Selection('ADC_SEL', "Mux31_adcSelA", "Mux31_adcSelB", "Mux31_adcSelC", 'PLL0PHI', 'PLL1PHI', 'XOSC');

	// ADC value
   	wizIntGetPropertyValue("ADC", 'val_adc',
   		freq_conversion);  	

	// SDADC multiplexor
    wizIntEditPropertyValue('SDADC_SEL', 'SDADC_selector', 'SDADC_selector');
    wizIntSetPropertyValue('SDADC_SEL', 'SDADC_input1', 'PLL0PHI');
    wizIntSetPropertyValue('SDADC_SEL', 'SDADC_input2', 'PLL1PHI');
    wizIntSetPropertyValue('SDADC_SEL', 'SDADC_input3', 'XOSC');
	wizIntMUX31Selection('SDADC_SEL', "Mux31_sdadcSelA", "Mux31_sdadcSelB", "Mux31_sdadcSelC", 'PLL0PHI', 'PLL1PHI', 'XOSC');

	// SDADC value
   	wizIntGetPropertyValue("SDADC", 'val_sdadc',
   		freq_conversion);  	

	// PCLK1 value
   	wizIntGetPropertyValue("PCLK1", 'val_pclk1',
   		freq_conversion);  	

	// PCLK2 value
   	wizIntGetPropertyValue("PCLK2", 'val_pclk2',
   		freq_conversion);  	

	// MCO value
   	wizIntGetPropertyValue("MCO", 'val_mco',
   		freq_conversion); 

	// MCO multiplexor
	wizIntEditPropertyValue('MCO_SEL', 'MCO_selector', 'MCO_selector');
    wizIntSetPropertyValue('MCO_SEL', 'MCO_input1', 'LSI');
    wizIntSetPropertyValue('MCO_SEL', 'MCO_input2', 'IRCOSC');
    wizIntSetPropertyValue('MCO_SEL', 'MCO_input3', 'XOSC');
    wizIntSetPropertyValue('MCO_SEL', 'MCO_input4', 'PLL0PHI');
    wizIntSetPropertyValue('MCO_SEL', 'MCO_input5', 'PLL1PHI');
	wizIntMUX51Selection('MCO_SEL', "Mux51_mcoSelA", "Mux51_mcoSelB", "Mux51_mcoSelC","Mux51_mcoSelD", "Mux51_mcoSelE", 'LSI', 'IRCOSC', 'XOSC', 'PLL0PHI', 'PLL1PHI');

	// RTC multiplexor
    wizIntEditPropertyValue('RTC_SEL', 'RTC_selector', 'RTC_selector');
//	wizIntSetPropertyValue('RTC_SEL', 'RTC_input1', 'LSI');
//    wizIntSetPropertyValue('RTC_SEL', 'RTC_input2', 'XOSC');
	wizIntMUX21Selection('RTC_SEL', "Mux21_rtcSelA", "Mux21_rtcSelB", 'LSI', 'XOSC');

	// RTC value
   	wizIntGetPropertyValue("RTC", 'val_rtc',
   		freq_conversion); 
   		
	// MCO value
   	wizIntGetPropertyValue("MCO", 'val_mco',
   		freq_conversion); 
   		
	//Dividers
	wizIntGetPropertyValue("SYSDIV", 'val_sysdiv', function(a) { return ":"+a; });
	wizIntEditPropertyValue('SYSDIV', 'val_sysdiv', 'SYSDIV_rect');
	wizIntSimpleToolTip('SYSDIV_rect', "Valid values are:/1,2,3,4, ... 512");
	

	wizIntGetPropertyValue("UARTDIV", 'val_uartdiv', function(a) { return ":"+a; });
	wizIntEditPropertyValue('UARTDIV', 'val_uartdiv', 'UART_div');
	wizIntSimpleToolTip('UART_div', "Valid values are:/1,2,3, ... 32")
	
	wizIntGetPropertyValue("I2CDIV", 'val_i2cdiv', function(a) { return ":"+a; });
	wizIntEditPropertyValue('I2CDIV', 'val_i2cdiv', 'I2C_DIV');
	wizIntSimpleToolTip('I2C_DIV', "Valid values are:/1,2,3, ... 32")

	wizIntGetPropertyValue("I2SDIV", 'val_i2sdiv', function(a) { return ":"+a; });
	wizIntEditPropertyValue('I2SDIV', 'val_i2sdiv', 'I2S_DIV');
	wizIntSimpleToolTip('I2S_DIV', "Valid values are:/1,2,3, ... 32")
		
	wizIntGetPropertyValue("FDCANDIV", 'val_fdcandiv', function(a) { return ":"+a; });
	wizIntEditPropertyValue('FDCANDIV', 'val_fdcandiv', 'FDCAN_DIV');
	wizIntSimpleToolTip('FDCAN_DIV', "Valid values are:/1,2,3, ... 32")
		
	wizIntGetPropertyValue("ADCDIV", 'val_adcdiv', function(a) { return ":"+a; });
	wizIntEditPropertyValue('ADCDIV', 'val_adcdiv', 'ADC_DIV');
	wizIntSimpleToolTip('ADC_DIV', "Valid values are:/1,2,4, ... 126")
		
	wizIntGetPropertyValue("SDADCDIV", 'val_sdadcdiv', function(a) { return ":"+a; });
	wizIntEditPropertyValue('SDADCDIV', 'val_sdadcdiv', 'SDADC_DIV');
	wizIntSimpleToolTip('SDADC_DIV', "Valid values are:/1,2,4, ... 126")
		
	wizIntGetPropertyValue("MCODIV", 'val_mcodiv', function(a) { return ":"+a; });
	wizIntEditPropertyValue('MCODIV', 'val_mcodiv', 'path_mcoSel');
	wizIntSimpleToolTip('path_mcoSel', "Valid values are:/1,2,4, ... 126")
	
	
	wizIntGetPropertyValue("LSIDIV", 'val_lsidiv', function(a) { return ":"+a; });
	wizIntEditPropertyValue('LSIDIV', 'val_lsidiv', 'LSI_DIV');
	wizIntSimpleToolTip('LSI_DIV', "Valid values are:/1,2,4, ... 62")
		
	var rtcdiv = Wizard.svgDoc.getElementById("val_rtcdiv");
	rtcdiv.textContent = ": 32";
	
	var enabled_XOSC = wizEngGetPropertyValue('','XOSC_Enabled');
	if( enabled_XOSC == "true" ) {
		wizIntDisplayOn('enabled_XOSC');
		wizIntDisplayOff('disabled_XOSC');
		wizIntCallMenu(
					"menu:{Disable XOSC:javaToggleBooleanProperty('XOSC_Enabled')}",
					'rect_XOSC');
	} else {
		wizIntDisplayOff('enabled_XOSC');
		wizIntDisplayOn('disabled_XOSC');
		wizIntCallMenu(
					"menu:{Enable XOSC:javaToggleBooleanProperty('XOSC_Enabled')}",
					'rect_XOSC');
	}

	var enabled_LSI = wizEngGetPropertyValue('','LSI_Enabled');
	if( enabled_LSI == "true" ) {
		wizIntDisplayOn('enabled_LSI');
		wizIntDisplayOff('disabled_LSI');
		wizIntCallMenu(
					"menu:{Disable LSI:javaToggleBooleanProperty('LSI_Enabled')}",
					'rect_LSI');
	} else {
		wizIntDisplayOff('enabled_LSI');
		wizIntDisplayOn('disabled_LSI');
		wizIntCallMenu(
					"menu:{Enable LSI:javaToggleBooleanProperty('LSI_Enabled')}",
					'rect_LSI');
	}
	
}
