/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.sr5e1.clocktree.editor;

import java.net.URL;
import java.util.HashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.osgi.framework.Bundle;

public class ClockEditorActionContributor
extends EditorActionBarContributor {
    private static Logger LOGGER = LogManager.getLogger(ClockEditorActionContributor.class);
    private ImageRegistry imageRegistry;
    public static final String IMG_CLOCKTREE = "clocktree";
    public static final String IMG_RESET = "reset";

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        Action openClocktreeAction = new Action(this, "OpenClocktree", 1){

            public void run() {
                String commandId = "com.st.stellar.component.sr5e1.clocktree.openBrowser";
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand(commandId);
                EvaluationContext context = new EvaluationContext(null, (Object)"selection");
                try {
                    command.executeWithChecks(new ExecutionEvent(command, new HashMap(), null, (Object)context));
                }
                catch (ExecutionException executionException) {
                }
                catch (NotDefinedException notDefinedException) {
                }
                catch (NotEnabledException notEnabledException) {
                }
                catch (NotHandledException notHandledException) {
                    // empty catch block
                }
            }
        };
        openClocktreeAction.setImageDescriptor(this.objectToImageDescriptor(this.getImage(IMG_CLOCKTREE)));
        openClocktreeAction.setToolTipText("Open the visual clock tree");
        toolBarManager.add((IAction)openClocktreeAction);
        Action resetToDefaultAction = new Action(this, "ResetToDefault", 1){

            public void run() {
                String commandId = "com.st.stellar.component.sr5e1.clocktree.resetToDefault";
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand(commandId);
                EvaluationContext context = new EvaluationContext(null, (Object)"selection");
                try {
                    command.executeWithChecks(new ExecutionEvent(command, new HashMap(), null, (Object)context));
                }
                catch (ExecutionException executionException) {
                }
                catch (NotDefinedException notDefinedException) {
                }
                catch (NotEnabledException notEnabledException) {
                }
                catch (NotHandledException notHandledException) {
                    // empty catch block
                }
            }
        };
        resetToDefaultAction.setImageDescriptor(this.objectToImageDescriptor(this.getImage(IMG_RESET)));
        resetToDefaultAction.setToolTipText("Reset the clock tree values to their default state");
        toolBarManager.add((IAction)resetToDefaultAction);
    }

    protected ImageDescriptor objectToImageDescriptor(Object object) {
        return ExtendedImageRegistry.getInstance().getImageDescriptor(object);
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            Path path = new Path("icons/" + fileName);
            Bundle uiBundle = Platform.getBundle((String)"com.st.stellar.component.sr5e1.clocktree.editor");
            URL url = FileLocator.find((Bundle)uiBundle, (IPath)path, null);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        return null;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.createImageRegistry();
            this.initializeImageRegistry(this.imageRegistry);
        }
        return this.imageRegistry;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.registerImage(reg, IMG_CLOCKTREE, "clocktree.png");
        this.registerImage(reg, IMG_RESET, "reset.png");
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }
}

