package com.st.stellar.component.sr5e1_can.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_can.Sr5e1_can
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

import com.st.stellar.component.sr5e1_can.irq_mask_t_support
import com.st.stellar.component.sr5e1_can.ts_mode_t

class Sr5e1_canCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}
	
	def String generateSr5e1_canCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}
	
	def String generateSr5e1_canCbfunc(Sr5e1_can component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* These callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			/* DMA error callback */
			if (!f.CAN_CB.isNullOrEmpty() && !cbfunc_list.contains(f.CAN_CB)) {
				res = res + '''

					void «f.CAN_CB»(can_driver_t *cdp, can_frame_t frame, can_evt_t event);
				'''
				cbfunc_list.add(f.CAN_CB)
			}
			/* Regular conversion callback */
			if (!f.CAN_ERROR_CB.isNullOrEmpty() && !cbfunc_list.contains(f.CAN_ERROR_CB)) {
				res = res + '''

					void «f.CAN_ERROR_CB»(can_driver_t *cdp, uint32_t psr);
				'''
				cbfunc_list.add(f.CAN_ERROR_CB)
			}
		}

		return res
	}
	
	def String generateSr5e1_canExportedFunctions(Sr5e1_can component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void can_«f.name»(can_driver_t *cdp);
			'''
		}
		header2
	}
	
	def String generateSr5e1_canHeader(Sr5e1_can component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "can_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_canCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <can.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_canCbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_canExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_canCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid CAN Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}
	
	def String generateSr5e1_canData(Sr5e1_can component) {
		var res = ""

		for (f : component.configs.filter[enabled]) {
			
			res = res + '''
			«IF (f.DMU_mode_enable == true)»
			/* Regular conversions DMA configuration.*/
			static can_dma_conf_t «f.name»_dma_conf = {
				«f.dma_stream_tx_id.getName()»,
				«f.dma_stream_rx0_id.getName()»,
			    «f.dma_stream_rx1_id.getName()»,
				«f.dma_stream_bus_prio.getName()»,
				«f.dma_stream_irq_prio.getName()»
				};
			«ENDIF»
			'''
		}
		return (res)
	}
	
	

	def String generateSr5e1_canCode(Sr5e1_can component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "can_cfg"

		if (error.severity == Diagnostic.OK) {
			'''
				«generateSr5e1_canCopyright()»

				#include <«filename».h>
				#include <dma.h>
				#include <irq.h>
				
				/* Internal configuration data.*/
				«generateSr5e1_canData(component)»

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					void can_«f.name»(can_driver_t *cdp) {
						
						/* Configure can driver instance.*/
						(void)can_set_prio(cdp, «f.priority.getName()»);
						(void)can_set_loopback(cdp, «f.loopback_mode.getName()»);
						«IF(f.enable_CAN_FD_mode)»
						(void)can_set_datasize(cdp, «f.data_field_size.getName()»);
						«ELSE»
						(void)can_set_datasize(cdp, CAN_DATASIZE_8BYTE);
						«ENDIF»
						(void)can_set_tx_mode(cdp, «f.tx_mode.getName()»);
						(void)can_set_rx_polling_mode(cdp, «f.enable_read_polling»);
						(void)can_set_ts_mode(cdp, «f.timestamp_source.getName()»);
						«IF(f.timestamp_source != ts_mode_t.CAN_TIMESTAMP_MODE_NONE && f.timestamp_source != ts_mode_t.CAN_TIMESTAMP_MODE_TIM_TS)»
						(void)can_set_ts_presc(cdp, «f.timestamp_prescaler - 1»U);
						«ENDIF»
						«IF(f.custom_ram == true)»
						
						/* Custom RAM configuration.*/
						(void)can_set_ram(cdp, «f.ram_start», «f.ram_size»);
						«ENDIF»
						
						/* Baudrate configuration.*/
						
						/* Nominal CAN configuration.*/
						(void)can_set_nbtp(cdp, «f.nbrp - 1», «f.ntseg1 - 1», «f.ntseg2 - 1», «f.nsjw - 1»);
						«IF(f.enable_CAN_FD_mode == true)»
						/* CAN-FD configuration.*/
						(void)can_set_fd_mode(cdp, «f.enable_CAN_FD_mode»);
						(void)can_set_fd_brs_mode(cdp, «f.enable_CAN_FD_bit_rate_switch»);
						(void)can_set_dbtp(cdp, «f.dbrp - 1», «f.dtseg1 - 1», «f.dtseg2 - 1», «f.dsjw - 1»);
						(void)can_enable_tdc(cdp, «f.delay_compensation»);
						(void)can_set_tdc(cdp, «f.tdco», «f.tdcf»);
						
						«ENDIF»
						
						«IF (f.filters.length > 0)»
						/* Filters configuration.*/
						«FOR filter : f.filters»
						(void)can_set_filter(cdp, «filter.id1», «filter.id2», «filter.message_filter.getName()», «filter.filter_type.getName()», «filter.fec_type.getName()»);
						«ENDFOR»
						«ENDIF»
						
						/* Buffers configuration.*/
						(void)can_set_buffers(cdp, «f.rx_buff_num», «f.tx_buff_num», «f.rx_fifo0_num», «f.rx_fifo1_num», «f.tx_fifoq_num», «f.txe_fifo_num»);
						
						«IF (f.DMU_mode_enable == true)»
						/* DMU mode configuration.*/
						(void)can_set_dmu_mode(cdp, «f.DMU_mode_enable»);
						(void)can_set_dma_conf(cdp, &«f.name»_dma_conf);
						«ENDIF»
						
						«IF (f.IRQ_mask != irq_mask_t_support.CAN_IRQ_ALL_DISABLED)»
						/* Configure interrupts.*/
						(void)can_set_irq_line(cdp, «f.IRQ_line.getName()»);
						
						«IF (f.IRQ_mask == irq_mask_t_support.CAN_IRQ_ALL_ENABLED)»
						(void)can_set_irq_mask(cdp, «f.IRQ_mask.getName()»);
						«ELSE»
						«IF (f.custom_IRQ_mask.length > 0)»
						«var len = f.custom_IRQ_mask.length»
						(void)can_set_irq_mask(cdp, «FOR mask : f.custom_IRQ_mask»«mask.getName()»«IF(len!=1)» | «ENDIF»«{len--; ""}»«ENDFOR»);
						«ENDIF»
						«ENDIF»
						«ENDIF»
						«IF (!f.CAN_CB.isNullOrEmpty())»
						/* Operation callback configuration.*/
						(void)can_set_cb(cdp, «f.CAN_CB»);
						«ENDIF»
						«IF (!f.CAN_ERROR_CB.isNullOrEmpty())»
						
						/* Error callback configuration.*/
						(void)can_set_err_cb(cdp, «f.CAN_ERROR_CB»);
						«ENDIF»
					}
				«ENDFOR»
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
