package com.st.stellar.component.sr5e1_can.impl

import com.st.stellar.clocktree.api.ClockAPI
import com.st.stellar.component.API.ComponentAPI
import com.st.stellar.component.Component
import com.st.stellar.component.DependsOn
import com.st.stellar.component.DependsOnExternalAttributes
import com.st.stellar.component.sr5e1_can.Configuration
import com.st.stellar.component.sr5e1_can.Sr5e1_canPackage
import com.st.stellar.external.api.ExternalAPIFactory
import org.eclipse.core.resources.IProject
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.emf.ecore.EObject
import com.st.stellar.component.API.ExternalAttributeValueResult
import com.st.stellar.component.sr5e1.can.Activator

// This class overrides the generated class and will be instantiated by factory
class ConfigurationImpl extends MConfigurationImpl implements Configuration {

	new() {
	}

	override getName() {
		if (name.isNullOrEmpty) {
			val parent = eContainer as Sr5e1_canImpl
			name = parent.createName
		}
		name
	}

	static def IProject getProject(EObject model) {
		var IProject project = null
		val uri = model.eResource().getURI();
		if (!uri.isFile()) {
			project = null;
		}
		val projectName = uri.segmentsList().get(1).toString()
		project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		return project;
	}

	@DependsOn(source=Sr5e1_canPackage.CONFIGURATION__BAUDRATE, dependencies=#[
		Sr5e1_canPackage.CONFIGURATION__NBRP,
		Sr5e1_canPackage.CONFIGURATION__NTSEG1,
		Sr5e1_canPackage.CONFIGURATION__NTSEG2,
		Sr5e1_canPackage.CONFIGURATION__CAN_CLOCK
	])
	override getBaudrate() {

		var baud = 1 / nbrp.doubleValue / (ntseg1.doubleValue + ntseg2.doubleValue + 1.0)

		if (baud == Double.POSITIVE_INFINITY) {
			return Double.NaN;
		}

		baud = (baud * 10000).intValue;

		baud = baud / 10000;

		return baud * can_clock;
	}

	// Current clock object being observed
	Component currentClock = null

	@DependsOnExternalAttributes(destination=Sr5e1_canPackage.CONFIGURATION__CAN_CLOCK, extensions=#[
		"com.st.stellar.component.sr5x.clocktree"], paths=#["Attribute:FDCAN"])
	override getCan_clock() {
		var value = super.getCan_clock()

		// Display a popup whenever the value previously stored for can clock differs from the
		// current value inside clock configurator
		if (ComponentAPI.isEnabled(this)) {
			val api = ExternalAPIFactory.INSTANCE.getAPI("ClockAPI") as ClockAPI; // $NON-NLS-1$
			if (api !== null) {
				val result = ComponentAPI.getAttributeValue(this,
					Long.valueOf(value), 
					api,
					"getClockPoint",
					this,
					currentClock,					
					"com.st.stellar.component.sr5x.clocktree",
					"FDCAN",
					Sr5e1_canPackage.eINSTANCE.getConfiguration_Can_clock(),
					Long.valueOf(value)
				);
				if( ExternalAttributeValueResult.isInstance(result) ) {
					val r = result as ExternalAttributeValueResult
					if( r.component === null) {
						ComponentAPI.displayPopup(this, Sr5e1_canPackage.eINSTANCE.configuration_Can_clock, r.value, value)
					} else {
						value = Long.valueOf(r.value.toString)
					}
					currentClock = r.component
				}
			}
			
		}

		return value
	}

	@DependsOn(source=Sr5e1_canPackage.CONFIGURATION__BAUDRATE_FD, dependencies=#[
		Sr5e1_canPackage.CONFIGURATION__DBRP,
		Sr5e1_canPackage.CONFIGURATION__DTSEG1,
		Sr5e1_canPackage.CONFIGURATION__DTSEG2,
		Sr5e1_canPackage.CONFIGURATION__CAN_CLOCK
	])
	override getBaudrateFD() {

		var baud = 1 / dbrp.doubleValue / (dtseg1.doubleValue + dtseg2.doubleValue + 1.0);

		if (baud == Double.POSITIVE_INFINITY) {
			return Double.NaN;
		}

		baud = (baud * 10000).intValue;

		baud = baud / 10000;

		val res = baud * can_clock;
		return res
	}
}
