package com.st.stellar.component.sr5e1_can.impl

import com.st.stellar.component.AttributeAPI
import com.st.stellar.component.AttributeReference
import com.st.stellar.component.sr5e1_can.Sr5e1_can
import com.st.stellar.component.sr5e1_can.Sr5e1_canPackage
import com.st.stellar.component.sr5e1_can.validation.MySr5e1_canValidator
import com.st.stellar.external.api.ExternalAPIFactory
import java.util.List
import java.util.regex.Pattern
import org.eclipse.emf.common.util.URI
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EValidator

// This class overrides the generated class and will be instantiated by factory
class Sr5e1_canImpl extends MSr5e1_canImpl implements Sr5e1_can {

	static boolean initialized = false

	static def initializeOnce() {
		if (!initialized) {
			initialized = true
			EValidator.Registry.INSTANCE.put(Sr5e1_canPackage.eINSTANCE, new EValidator.Descriptor() {
				override getEValidator() {
					return MySr5e1_canValidator.INSTANCE
				}
			});
		}
		val api = ExternalAPIFactory.INSTANCE.getAPI("AttributeAPI") as AttributeAPI; // $NON-NLS-1$
		if (api !== null) {
			val ref2 = new AttributeReference() {

				override EAttribute getAttribute(EObject comp) {
					val attr = comp.eClass().getEAttributes().stream().filter(a|a.getName().equals("can_clock")).
						findFirst();
					if (attr.isPresent()) {
						return attr.get()
					} else {
						return null
					}
				}
			};
			api.addAttribute("FDCAN", ref2, "com.st.stellar.component.sr5x.clocktree");
		}

	}

	new() {
		initializeOnce();
	}

	def createName() {
		var chosen_name = ""
		var i = 1
		val name_list = configs.map[(it as MConfigurationImpl).name]

		chosen_name = getName + i
		var found = !name_list.contains(chosen_name)
		while (!found) {
			i++
			chosen_name = getName + i
			found = !name_list.contains(chosen_name)
		}
		chosen_name
	}

	override getName() {
		if (this.eResource !== null) {
			fileName(this.eResource.getURI())
		} else {
			super.getName()
		}
	}

	private def String fileName(URI uri) {
		val len = uri.segmentCount()
		if (len == 0) {
			return null
		}

		val lastSegment = uri.segment(len - 1)
		val i = lastSegment.lastIndexOf('.')
		return i < 0 ? null : lastSegment.substring(0, i)
	}

	def static List<Integer> extractIntegersFromString(String s) {
		var integers = newArrayList
		val pattern = Pattern.compile("\\d+");
		val matcher = pattern.matcher(s);

		while (matcher.find()) {
			integers.add(Integer.parseInt(matcher.group()));
		}

		return integers;
	}

}
