/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.sr5e1_can.validation;

import com.google.common.collect.Iterables;
import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.API.Utils;
import com.st.stellar.component.Application;
import com.st.stellar.component.ComponentReference;
import com.st.stellar.component.sr5e1_can.Configuration;
import com.st.stellar.component.sr5e1_can.MSr5e1_canPackage;
import com.st.stellar.component.sr5e1_can.Sr5e1_can;
import com.st.stellar.component.sr5e1_can.Sr5e1_canPackage;
import com.st.stellar.component.sr5e1_can.impl.MConfigurationImpl;
import com.st.stellar.component.sr5e1_can.impl.Sr5e1_canImpl;
import com.st.stellar.component.sr5e1_can.irq_mask_t;
import com.st.stellar.component.sr5e1_can.ts_mode_t;
import com.st.stellar.component.sr5e1_can.util.Sr5e1_canValidator;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MySr5e1_canValidator
extends Sr5e1_canValidator {
    public static final MySr5e1_canValidator INSTANCE = new MySr5e1_canValidator();
    private Sr5e1_can currentComponent = null;
    private Configuration currentConfiguration = null;
    private static final String ISSUE_CODE_PREFIX = "com.st.stellar.component.sr5e1_can.";
    private static final String WRONG_NAME = "com.st.stellar.component.sr5e1_can.wrongName";
    private static final String WRONG_HEX = "com.st.stellar.component.sr5e1_can.wrongHexadecimal";
    private static final String WRONG_CB = "com.st.stellar.component.sr5e1_can.wrongCallback";
    private static final String WRONG_PATH = "com.st.stellar.component.sr5e1_can.wrongPath";
    public static final String WRONG_GENPATH = "com.st.stellar.component.sr5e1_can.wrongGenPath";
    private static final Pattern REGEX_HEX = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("^0x[0-9a-fA-F]{8}$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern REGEX_NAME = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("^[a-zA-Z]+[a-zA-Z0-9_]*$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern REGEX_CB = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("^([a-zA-Z][a-zA-Z0-9_-]*)?$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern REGEX_PATH = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("^[a-zA-Z0-9-_]+[a-zA-Z0-9-/\\\\_]*$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final String MISSING_EXTERNAL_LINK = "com.st.stellar.component.sr5e1_can.missingExternalLink";
    private static final int CAN_CODE = 98;
    private static final int CONFIG_CODE = 99;

    @Override
    public boolean validateConfiguration(Configuration configuration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean _xblockexpression = false;
        EObject _eContainer = configuration.eContainer();
        this.currentComponent = (Sr5e1_can)_eContainer;
        this.currentConfiguration = configuration;
        _xblockexpression = super.validateConfiguration(configuration, diagnostics, context);
        return _xblockexpression;
    }

    @Override
    public boolean validateSr5e1_can(Sr5e1_can comp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.currentComponent = comp;
        boolean res = super.validateSr5e1_can(comp, diagnostics, context);
        return res;
    }

    @Override
    public boolean validatename_t_checkName(String nameToValidate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        if (parent == null) {
            return true;
        }
        boolean res = this.checkName(nameToValidate, diagnostics, context);
        if (!res && diagnostics != null) {
            String _valueLabel = EObjectValidator.getValueLabel((EDataType)MSr5e1_canPackage.Literals.NAME_T, (Object)nameToValidate, context);
            diagnostics.add((Diagnostic)this.createDiagnostic(4, WRONG_NAME, 99, "_UI_GenericConstraint_diagnostic", new Object[]{"checkName", _valueLabel}, new Object[]{nameToValidate}, context));
            res = false;
        }
        return res;
    }

    @Override
    public boolean validatePath_checkPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        if (parent == null) {
            return true;
        }
        boolean res = this.checkInputPath(path, diagnostics, context);
        if (!res && diagnostics != null) {
            String _valueLabel = EObjectValidator.getValueLabel((EDataType)MSr5e1_canPackage.Literals.PATH, (Object)path, context);
            diagnostics.add((Diagnostic)this.createDiagnostic(4, WRONG_PATH, 99, "_UI_GenericConstraint_diagnostic", new Object[]{"checkPath", _valueLabel}, new Object[]{path}, context));
            res = false;
        }
        return res;
    }

    public boolean checkInputPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
        boolean _xblockexpression = false;
        Sr5e1_can comp = this.currentComponent;
        if (comp == null) {
            return true;
        }
        IProject project = MySr5e1_canValidator.getProject((EObject)comp);
        String _oSString = project.getLocation().toOSString();
        String _plus = _oSString + File.separator;
        String fileName = _plus + location;
        Path path = new Path(fileName);
        boolean res = false;
        boolean _isValidPath = path.isValidPath(fileName);
        if (_isValidPath) {
            File file = new File(fileName);
            res = file.exists();
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    @Override
    public boolean validategenpath_t_checkGenPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        if (parent == null) {
            return true;
        }
        boolean res = this.checkPath(path, diagnostics, context);
        if (!res && diagnostics != null) {
            String _valueLabel = EObjectValidator.getValueLabel((EDataType)MSr5e1_canPackage.Literals.GENPATH_T, (Object)path, context);
            diagnostics.add((Diagnostic)this.createDiagnostic(4, WRONG_GENPATH, 99, "_UI_GenericConstraint_diagnostic", new Object[]{"checkPath", _valueLabel}, new Object[]{path}, context));
            res = false;
        }
        return res;
    }

    @Override
    public boolean validateuint32_t_checkUINT32_T(Integer uint32_t, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        if (parent == null) {
            return true;
        }
        return uint32_t >= 0 && (long)uint32_t.intValue() <= 0xFFFFFFFFL;
    }

    @Override
    public boolean validatedbrp_t_checkDbrp_t(Integer dbrp_t, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        Configuration config = this.currentConfiguration;
        if (parent == null) {
            return true;
        }
        boolean _isDelay_compensation = config.isDelay_compensation();
        if (_isDelay_compensation) {
            return dbrp_t >= 1 && dbrp_t <= 2;
        }
        return dbrp_t >= 1 && dbrp_t <= 32;
    }

    @Override
    public boolean validatets_presc_t_checkTs_presc_t(Integer ts_presc_t, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        Configuration config = this.currentConfiguration;
        if (parent == null) {
            return true;
        }
        ts_mode_t src = config.getTimestamp_source();
        boolean _equals = Objects.equals((Object)src, (Object)ts_mode_t.CAN_TIMESTAMP_MODE_INT);
        if (_equals) {
            return ts_presc_t >= 1 && ts_presc_t <= 16;
        }
        if (Objects.equals((Object)src, (Object)ts_mode_t.CAN_TIMESTAMP_MODE_EXT) || Objects.equals((Object)src, (Object)ts_mode_t.CAN_TIMESTAMP_MODE_TSU)) {
            return ts_presc_t >= 1 && ts_presc_t <= 256;
        }
        return true;
    }

    @Override
    public boolean validateirq_mask_t_checkIRQMask(irq_mask_t irq_mask_t2, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        Configuration config = this.currentConfiguration;
        int counter = 0;
        if (parent == null) {
            return true;
        }
        Functions.Function1 _function = ch -> ch.getLiteral();
        List irqs = ListExtensions.map(config.getCustom_IRQ_mask(), (Functions.Function1)_function);
        if (irqs == null) {
            return true;
        }
        for (String irq : irqs) {
            String _literal;
            boolean _equals = Objects.equals(irq, _literal = irq_mask_t2.getLiteral());
            if (!_equals) continue;
            ++counter;
        }
        if (counter >= 2) {
            if (diagnostics != null) {
                String _valueLabel = EObjectValidator.getValueLabel((EDataType)MSr5e1_canPackage.Literals.GENPATH_T, (Object)((Object)irq_mask_t2), context);
                diagnostics.add((Diagnostic)this.createDiagnostic(4, "com.st.stellar.component.sr5e1_can", 99, "_UI_GenericConstraint_diagnostic", new Object[]{"checkIRQMask", _valueLabel}, new Object[]{irq_mask_t2}, context));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validatehex_checkHex(String hex, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        if (parent == null) {
            return true;
        }
        boolean res = this.checkHex(hex, diagnostics, context);
        if (!res && diagnostics != null) {
            String _valueLabel = EObjectValidator.getValueLabel((EDataType)MSr5e1_canPackage.Literals.GENPATH_T, (Object)hex, context);
            diagnostics.add((Diagnostic)this.createDiagnostic(4, WRONG_HEX, 99, "_UI_GenericConstraint_diagnostic", new Object[]{"checkHex", _valueLabel}, new Object[]{hex}, context));
            res = false;
        }
        return res;
    }

    @Override
    public boolean validatecallback_t_checkCb(String callback_t, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        boolean res = true;
        if (parent == null) {
            return true;
        }
        EClass eClass = this.currentConfiguration.eClass();
        Functions.Function1 _function = it -> it.getEAttributeType().equals((Object)Sr5e1_canPackage.eINSTANCE.getcallback_t());
        Functions.Function1 _function_1 = attr -> {
            String value;
            String _xblockexpression = null;
            Object nameValue = this.currentConfiguration.eGet((EStructuralFeature)attr);
            String _xifexpression = null;
            _xifexpression = nameValue != null ? EcoreUtil.convertToString((EDataType)attr.getEAttributeType(), (Object)nameValue) : "";
            _xblockexpression = value = _xifexpression;
            return _xblockexpression;
        };
        Iterable callbackList = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)eClass.getEAllStructuralFeatures(), EAttribute.class), (Functions.Function1)_function), (Functions.Function1)_function_1));
        if (callbackList != null && !IterableExtensions.isEmpty((Iterable)callbackList)) {
            boolean thereAreDuplicates;
            Functions.Function1 _function_2 = it -> it.equals(callback_t) && callback_t.length() > 0;
            int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)callbackList, (Functions.Function1)_function_2));
            boolean bl = thereAreDuplicates = _size > 1;
            if (thereAreDuplicates) {
                if (diagnostics != null) {
                    String _valueLabel = EObjectValidator.getValueLabel((EDataType)MSr5e1_canPackage.Literals.CALLBACK_T, (Object)callback_t, context);
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, WRONG_CB, 99, "_UI_GenericConstraint_diagnostic", new Object[]{"duplicated callback name", _valueLabel}, new Object[]{callback_t}, context));
                }
                res = false;
                return res;
            }
        }
        if (!(res = this.checkCb(callback_t, diagnostics, context)) && diagnostics != null) {
            String _valueLabel_1 = EObjectValidator.getValueLabel((EDataType)MSr5e1_canPackage.Literals.CALLBACK_T, (Object)callback_t, context);
            diagnostics.add((Diagnostic)this.createDiagnostic(4, WRONG_CB, 99, "_UI_GenericConstraint_diagnostic", new Object[]{"checkPath", _valueLabel_1}, new Object[]{callback_t}, context));
            res = false;
        }
        return res;
    }

    public boolean checkHex(String hex, DiagnosticChain chain, Map<Object, Object> map) {
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        if (parent == null) {
            return true;
        }
        boolean matches = REGEX_HEX.matcher(hex).matches();
        return matches;
    }

    public boolean checkName(String nameToValidate, DiagnosticChain chain, Map<Object, Object> map) {
        boolean noDuplicates;
        boolean _xblockexpression = false;
        Sr5e1_canImpl parent = (Sr5e1_canImpl)this.currentComponent;
        if (parent == null) {
            return true;
        }
        boolean matches = REGEX_NAME.matcher(nameToValidate).matches();
        if (!matches) {
            return false;
        }
        Functions.Function1 _function = c -> c != this.currentConfiguration;
        Functions.Function1 _function_1 = it -> ((MConfigurationImpl)it).getName();
        List name_list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(parent.getConfigs(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        if (name_list == null) {
            return true;
        }
        Functions.Function1 _function_2 = it -> it.equals(nameToValidate);
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)name_list, (Functions.Function1)_function_2));
        _xblockexpression = noDuplicates = _size < 1;
        return _xblockexpression;
    }

    public boolean checkCb(String location, DiagnosticChain chain, Map<Object, Object> map) {
        boolean res;
        boolean _xblockexpression = false;
        Sr5e1_can comp = this.currentComponent;
        if (comp == null) {
            return true;
        }
        Matcher matcher = REGEX_CB.matcher(location);
        _xblockexpression = res = matcher.matches();
        return _xblockexpression;
    }

    public boolean checkPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
        boolean res;
        boolean _xblockexpression = false;
        Sr5e1_can comp = this.currentComponent;
        if (comp == null) {
            return true;
        }
        Matcher matcher = REGEX_PATH.matcher(location);
        _xblockexpression = res = matcher.matches();
        return _xblockexpression;
    }

    public static IProject getProject(EObject model) {
        URI uri = model.eResource().getURI();
        String projectName = ((String)uri.segmentsList().get(1)).toString();
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    @Override
    public boolean validateSr5e1_can_checkExternalLinks(Sr5e1_can sr5e1_can, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean _not;
        boolean _tripleEquals;
        boolean res = true;
        Resource _eResource = this.currentComponent.eResource();
        boolean bl = _tripleEquals = _eResource == null;
        if (_tripleEquals) {
            return true;
        }
        Application app = ComponentAPI.getApplication((Resource)this.currentComponent.eResource());
        IFile file = Utils.getFileFromResource((URI)this.currentComponent.eResource().getURI());
        IProject project = file.getProject();
        EList expectedConfigurators = this.currentComponent.getRequiredFeatures();
        HashSet<String> missingFeatures = new HashSet<String>();
        List _removeDuplicates = Utils.removeDuplicates((List)expectedConfigurators);
        for (String expectedConfigurator : _removeDuplicates) {
            HashSet configuratorsList = CollectionLiterals.newHashSet();
            Functions.Function1 _function = it -> it.isEnabled();
            Iterable _filter = IterableExtensions.filter((Iterable)app.getComponents(), (Functions.Function1)_function);
            for (ComponentReference ref : _filter) {
                String _name = project.getName();
                String _plus = "/" + _name;
                String _plus_1 = _plus + "/";
                String uriToValidateStr = _plus_1 + expectedConfigurator;
                URI uriToValidate = URI.createPlatformResourceURI((String)uriToValidateStr, (boolean)true);
                boolean _isEnabled = ComponentAPI.isEnabled((String)uriToValidate.toString());
                if (!_isEnabled) continue;
                configuratorsList.add(ref.toString());
            }
            boolean _isEmpty = configuratorsList.isEmpty();
            if (!_isEmpty) continue;
            missingFeatures.add(expectedConfigurator);
        }
        boolean _isEmpty = missingFeatures.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            if (diagnostics != null) {
                for (String configurator : missingFeatures) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Missing configurator '");
                    _builder.append(configurator);
                    _builder.append("' in application.");
                    BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, MISSING_EXTERNAL_LINK, 98, _builder.toString(), new Object[]{sr5e1_can});
                    diagnostics.add((Diagnostic)_basicDiagnostic);
                }
            }
            res = false;
        }
        return res;
    }

    @Override
    public boolean validateFDCAN_VALUE_checkExternalLinks(long fdcaN_VALUE, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }
}

