package com.st.stellar.component.sr5e1_can.editor;

import com.st.stellar.component.API.Utils
import com.st.stellar.component.model.ui.ComponentValidationLabelDecoratorProvider
import com.st.stellar.component.model.ui.ComponentValidationServiceLabelDecorator
import com.st.stellar.component.sr5e1_can.Configuration
import com.st.stellar.component.sr5e1_can.Sr5e1_can
import org.eclipse.emf.common.notify.Notifier
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emfforms.common.Optional
import org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic.DiagnosticCache
import org.eclipse.jface.viewers.ILabelDecorator
import org.eclipse.jface.viewers.TreeViewer

class Sr5e1_canLabelDecoratorProvider extends ComponentValidationLabelDecoratorProvider {

	new(Notifier input) {
		super(input)
	}

	override Optional<ILabelDecorator> getLabelDecorator(TreeViewer viewer) {
		decorator = new MyLabelServiceDecorator(viewer, input, cache)
		return Optional.<ILabelDecorator>of(decorator)
	}
}

class MyLabelServiceDecorator extends ComponentValidationServiceLabelDecorator {

	new(TreeViewer viewer, Notifier input, DiagnosticCache cache) {
		super(viewer, input, cache)
	}

	override String decorateText(String text, Object element) {
		return this.format(element, text);
	}

	dispatch def format(Sr5e1_can object, String text) {
		val error = Diagnostician.INSTANCE.validate(object)
		if (error.getSeverity() == Diagnostic.OK) {
			return object.name
		} else {
			val mess = Utils.populateDiagnostics(error, 98)
			if (mess !== null && !mess.isEmpty) {
				return object.name + " -> " + mess;
			} else {
				return object.name
			}
		}
	}

	dispatch def format(Configuration object, String text) {
		val error = Diagnostician.INSTANCE.validate(object)

		if (error.getSeverity() == Diagnostic.OK) {
			return object.name
		} else {
			val mess = Utils.populateDiagnostics(error, 99)
			if (mess !== null && !mess.isEmpty) {
				return object.name + " -> " + mess;
			} else {
				return object.name
			}
		}
	}

	dispatch def format(Object object, String text) {
		return text
	}
}
